/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.integration.terra_entity.npc_trade;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import org.confluence.mod.common.component.ValueComponent;
import org.confluence.mod.integration.terra_entity.init.ModTradeProviders;
import org.confluence.mod.integration.terra_entity.npc_trade.IMoneyTrade;
import org.confluence.terraentity.api.npc.trade.ITradeHolder;
import org.confluence.terraentity.api.npc.trade.ITradeItem;
import org.confluence.terraentity.api.npc.trade.ITradeLock;
import org.confluence.terraentity.registries.npc_trade.TradeProperties;
import org.confluence.terraentity.registries.npc_trade.TradeProvider;

public class DeferredMoneyTradeItem
implements ITradeItem,
IMoneyTrade {
    public static final MapCodec<DeferredMoneyTradeItem> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ResourceLocation.CODEC.fieldOf("deferred_result").forGetter(trade -> trade.deferredResult), (App)ExtraCodecs.intRange((int)1, (int)9999).lenientOptionalFieldOf("count", (Object)1).forGetter(trade -> trade.count), (App)ITradeLock.TYPED_CODEC.fieldOf("lock").forGetter(trade -> trade.properties.lock())).apply((Applicative)instance, DeferredMoneyTradeItem::new));
    private final ResourceLocation deferredResult;
    private final int count;
    private final TradeProperties properties;
    private ItemStack cachedResult = ItemStack.EMPTY;

    public DeferredMoneyTradeItem(ResourceLocation deferredResult, int count, ITradeLock lock) {
        this.deferredResult = deferredResult;
        this.count = count;
        this.properties = new TradeProperties(lock);
    }

    public ItemStack result() {
        if (this.cachedResult == ItemStack.EMPTY) {
            Item item = (Item)BuiltInRegistries.ITEM.get(this.deferredResult);
            this.cachedResult = item == Items.AIR ? Items.BARRIER.getDefaultInstance() : new ItemStack((ItemLike)item, this.count);
        }
        return this.cachedResult;
    }

    public TradeProperties properties() {
        return this.properties;
    }

    @Override
    public void onTrade(ServerPlayer player, ITradeHolder npc, int index) {
        IMoneyTrade.super.onTrade(player, npc, index);
    }

    @Override
    public void onTradeSuccess(ServerPlayer player, ITradeHolder npc, int index, long cost) {
        ItemStack result = this.result();
        if (player.getInventory().getFreeSlot() == -1) {
            player.drop(result.copy(), false);
        } else {
            player.addItem(result.copy());
        }
    }

    @Override
    public long cost() {
        return (long)ValueComponent.getValue(this.result(), 0) * 5L;
    }

    public TradeProvider getCodec() {
        return ModTradeProviders.DEFERRED_MONEY_TRADE_ITEM.get();
    }
}

