/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.integration.terra_entity;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.CrossbowItem;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import org.confluence.lib.color.GlobalColors;
import org.confluence.lib.util.LibUtils;
import org.confluence.mod.Confluence;
import org.confluence.mod.common.attachment.PlayerSpecialData;
import org.confluence.mod.common.data.saved.Bestiary;
import org.confluence.mod.common.data.saved.NPCSpawner;
import org.confluence.mod.common.menu.NPCTradesForgeMenu;
import org.confluence.mod.integration.terra_entity.IAbstractTerraNPC;
import org.confluence.mod.integration.terra_entity.brain.ConfluenceDemolitionistNPCAi;
import org.confluence.mod.integration.terra_entity.npc_trade.SellTrade;
import org.confluence.mod.util.AchievementUtils;
import org.confluence.terraentity.api.event.NPCEvent;
import org.confluence.terraentity.api.event.SummonEvent;
import org.confluence.terraentity.api.event.YoyosThrowingEvent;
import org.confluence.terraentity.api.npc.trade.ITrade;
import org.confluence.terraentity.api.npc.trade.ITradeHolder;
import org.confluence.terraentity.attachment.SummonerAttachment;
import org.confluence.terraentity.entity.npc.AbstractTerraNPC;
import org.confluence.terraentity.entity.npc.AnglerNPC;
import org.confluence.terraentity.entity.npc.brain.NPCAi;
import org.confluence.terraentity.entity.npc.brain.NurseAi;
import org.confluence.terraentity.init.TEAttachments;
import org.confluence.terraentity.init.entity.TENpcEntities;
import org.confluence.terraentity.registries.npc_trade_task.variant.DynamicAnglerTradeTask;

@EventBusSubscriber(modid="confluence")
public final class TEGameEvents {
    @SubscribeEvent
    public static void onTravelMerchantGenerator(NPCEvent.TravelingMerchantGenerateTradeEvent event) {
        if (event.getNPC().getType() == TENpcEntities.TRAVELING_MERCHANT.get()) {
            int addition = NPCSpawner.INSTANCE.isPeddlersSatchelUsed() ? 1 : 0;
            int count = event.getNPC().getRandom().nextInt(4, 10);
            event.addTrade((ITrade)SellTrade.INSTANCE);
            event.setGenerateCount(count + addition);
        }
    }

    @SubscribeEvent
    public static void onInitNpcTrade(NPCEvent.InitNPCTradeEvent event) {
        if (event.getNPC().getType() == TENpcEntities.FEMALE_ANGLER.get()) {
            event.setRedirection(Confluence.asResource(TENpcEntities.ANGLER.getId().getPath()));
        } else {
            event.setRedirection(Confluence.asResource(event.getOrigin().getPath()));
        }
    }

    @SubscribeEvent
    public static void onInteractNpc(NPCEvent.InteractNPCEvent event) {
        event.setRedirection((npc, player) -> {
            AnglerNPC angler;
            DynamicAnglerTradeTask task;
            if (npc.getTradeManager() != null) {
                npc.getTradeManager().reCheckAvailableTrades((Player)player);
            }
            EntityType type = npc.getType();
            player.openMenu((MenuProvider)new SimpleMenuProvider((id, inventory, player1) -> new NPCTradesForgeMenu(id, inventory, (ITradeHolder)npc, type == TENpcEntities.GOBLIN_TINKERER.get()), (Component)Component.translatable((String)"container.confluence.npc_shop")));
            IAbstractTerraNPC terraNPC = IAbstractTerraNPC.of(npc);
            if (terraNPC.confluence$shouldInteract()) {
                terraNPC.confluence$setShouldInteract(false);
                if (type == TENpcEntities.MECHANIC.get()) {
                    NPCSpawner.Region region = NPCSpawner.getNpcSpawnRegion(player);
                    terraNPC.confluence$setRegion(region);
                    NPCSpawner.INSTANCE.applyBenedictions((AbstractTerraNPC)npc);
                    NPCSpawner.INSTANCE.addSpawned(type);
                    NPCSpawner.broadcastMessageToRegion(player.level(), npc, (Component)Component.translatable((String)"event.confluence.npc.arrived", (Object[])new Object[]{type.getDescription(), npc.getName()}).withColor(GlobalColors.NPC_ARRIVED.get()));
                }
            }
            if (npc instanceof AnglerNPC && (task = (angler = (AnglerNPC)npc).getFirstTask()) != null) {
                PlayerSpecialData.of((Player)player).setCurrentQuestedFish(task.getCurrentCost(), task.getCurrentLock());
            }
            if (!Bestiary.INSTANCE.containsKey((LivingEntity)npc)) {
                Bestiary.INSTANCE.updateEntry((LivingEntity)npc, false);
            }
            event.setResult(InteractionResult.CONSUME_PARTIAL);
        });
    }

    @SubscribeEvent
    public static void onCollectBrains(NPCEvent.NPCBrainCollectionEvent event) {
        event.register((EntityType)TENpcEntities.DEMOLITIONIST.get(), collector -> {
            AbstractTerraNPC npc = collector.getNPC();
            collector.setReplace((NPCAi)new ConfluenceDemolitionistNPCAi(npc));
            npc.setAttackRange(5.0f);
            npc.setCanPerformerAttackTest(e -> true);
        });
        event.register((EntityType)TENpcEntities.GUIDE.get(), collector -> {
            AbstractTerraNPC npc = collector.getNPC();
            npc.setCanPerformerAttackTest(e -> e.getMainHandItem().getItem() instanceof BowItem);
        });
        event.register((EntityType)TENpcEntities.ARMS_DEALER.get(), collector -> {
            AbstractTerraNPC npc = collector.getNPC();
            npc.setAttackRange(10.0f);
            npc.setCooldownTicks(20);
            npc.setCanPerformerAttackTest(e -> e.getMainHandItem().getItem() instanceof CrossbowItem);
        });
        event.register((EntityType)TENpcEntities.GOBLIN_TINKERER.get(), collector -> {
            AbstractTerraNPC npc = collector.getNPC();
            npc.setCanPerformerAttackTest(e -> e.getMainHandItem().getItem() instanceof BowItem);
        });
        event.register((EntityType)TENpcEntities.NURSE.get(), collector -> collector.setReplace((NPCAi)new NurseAi(collector.getNPC())));
    }

    @SubscribeEvent
    public static void summon$Pre(SummonEvent.Pre<?> event) {
        ServerPlayer player;
        Player player2 = event.getEntity();
        if (player2 instanceof ServerPlayer && ((SummonerAttachment)(player = (ServerPlayer)player2).getData(TEAttachments.SUMMONER_STORAGE)).getIds().size() >= 8) {
            AchievementUtils.awardAchievement(player, "you_and_what_army");
        }
    }

    @SubscribeEvent
    public static void afterNpcTrade(NPCEvent.NPCTradeEvent.Post event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            if (event.getHolder() instanceof AnglerNPC) {
                CompoundTag data = LibUtils.getOrCreatePersistedData((Player)player2);
                int times = data.getInt("confluence:angler_task_times") + 1;
                String path = times >= 200 ? "supreme_helper_minion" : (times >= 50 ? "fast_and_fishious" : (times >= 25 ? "trout_monkey" : (times >= 10 ? "good_little_slave" : "servant_in_training")));
                AchievementUtils.awardAchievement(player2, path);
                data.putInt("confluence:angler_task_times", times);
            }
        }
    }

    @SubscribeEvent
    public static void yoyosThrowing(YoyosThrowingEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            AchievementUtils.awardAchievement(player2, "throwing_lines");
        }
    }
}

