/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.integration.terra_curio;

import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import org.confluence.mod.common.init.armor.ModArmorBonus;
import org.confluence.terra_curio.api.primitive.PrimitiveValue;
import org.confluence.terra_curio.api.primitive.ValueType;
import org.confluence.terra_curio.common.attachment.AccessoriesAttachment;
import org.confluence.terra_curio.common.component.PrimitiveValueComponent;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class WrappedAccessoriesAttachment
extends AccessoriesAttachment {
    private final AccessoriesAttachment original;
    private final Player player;

    public WrappedAccessoriesAttachment(Player player, AccessoriesAttachment original) {
        this.original = original;
        this.player = player;
    }

    public void setToDefaultValue() {
        if (this.original == null) {
            super.setToDefaultValue();
        } else {
            this.original.setToDefaultValue();
        }
    }

    public boolean hasPanicNecklace() {
        return this.original.hasPanicNecklace();
    }

    public void increaseLavaImmuneTicks() {
        this.original.increaseLavaImmuneTicks();
    }

    public boolean decreaseLavaImmuneTicks() {
        return this.original.decreaseLavaImmuneTicks();
    }

    public void flushAbility(LivingEntity living) {
        this.original.flushAbility(living);
    }

    public void compute(PrimitiveValueComponent component) {
        this.original.compute(component);
    }

    public <T, V extends PrimitiveValue<T>> void putUnitIfPresent(ValueType<T, V> type) {
        this.original.putUnitIfPresent(type);
    }

    public <T, V extends PrimitiveValue<T>> void combineValue(ValueType<T, V> type, V value) {
        this.original.combineValue(type, value);
    }

    public CompoundTag serializeNBT(HolderLookup.Provider provider) {
        return this.original.serializeNBT(provider);
    }

    public void deserializeNBT(HolderLookup.Provider provider, CompoundTag nbt) {
        this.original.deserializeNBT(provider, nbt);
    }

    public <T, V extends PrimitiveValue<T>> boolean contains(ValueType<T, V> type) {
        return this.original.contains(type) || ModArmorBonus.hasType(this.player, type);
    }

    public <T, V extends PrimitiveValue<T>> T getValue(ValueType<T, V> type) {
        Object called = this.original.getValue(type);
        T t = ModArmorBonus.getValue(this.player, type);
        if (called == null) {
            return t;
        }
        return (T)type.combineRule().combine(called, t);
    }

    @Nullable
    public <T, V extends PrimitiveValue<T>> V getPrimitiveValue(ValueType<T, V> type) {
        PrimitiveValue called = this.original.getPrimitiveValue(type);
        V v = ModArmorBonus.getPrimitiveValue(this.player, type);
        if (called == null) {
            return v;
        }
        if (v == null) {
            return (V)called;
        }
        return (V)type.newInstance(type.combineRule().combineValue(called, v));
    }
}

