/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.integration.jei.category;

import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.RecipeHolder;
import org.confluence.mod.Confluence;
import org.confluence.mod.common.init.block.FunctionalBlocks;
import org.confluence.mod.common.recipe.LoomRecipe;
import org.confluence.mod.integration.jei.EitherRecipe4xHelper;

public class LoomCategory
implements IRecipeCategory<RecipeHolder<LoomRecipe>> {
    public static final RecipeType<RecipeHolder<LoomRecipe>> TYPE = RecipeType.createRecipeHolderType((ResourceLocation)Confluence.asResource("loom"));
    private static final ResourceLocation BACKGROUND = Confluence.asResource("textures/gui/loom.png");
    private final IDrawable icon;
    private final EitherRecipe4xHelper helper;

    public LoomCategory(IJeiHelpers jeiHelpers) {
        this.icon = jeiHelpers.getGuiHelper().createDrawableItemStack(FunctionalBlocks.LOOM.toStack());
        this.helper = new EitherRecipe4xHelper(jeiHelpers.getIngredientManager());
    }

    public RecipeType<RecipeHolder<LoomRecipe>> getRecipeType() {
        return TYPE;
    }

    public Component getTitle() {
        return Component.translatable((String)"title.confluence.loom");
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public int getWidth() {
        return 144;
    }

    public int getHeight() {
        return 80;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, RecipeHolder<LoomRecipe> recipe, IFocusGroup focuses) {
        EitherRecipe4xHelper.setEitherRecipe4x(builder, recipe);
    }

    public void draw(RecipeHolder<LoomRecipe> recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        guiGraphics.blit(BACKGROUND, 0, 0, 0.0f, 0.0f, 144, 80, 144, 80);
        if (mouseX >= 80.0 && mouseX <= 108.0 && mouseY >= 29.0 && mouseY <= 52.0) {
            this.helper.drawSummary(recipeSlotsView, guiGraphics);
        }
    }

    public ResourceLocation getRegistryName(RecipeHolder<LoomRecipe> recipe) {
        return Confluence.asResource(((LoomRecipe)recipe.value()).getGroup() + "/" + BuiltInRegistries.ITEM.getKey((Object)((LoomRecipe)recipe.value()).getResultItem(null).getItem()).getPath());
    }
}

