/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.integration.jei.category;

import java.util.Collection;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.ITooltipBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.gui.widgets.IRecipeExtrasBuilder;
import mezz.jei.api.helpers.IJeiHelpers;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.RecipeHolder;
import org.confluence.mod.Confluence;
import org.confluence.mod.common.init.block.FunctionalBlocks;
import org.confluence.mod.common.recipe.CrystalBallRecipe;
import org.confluence.mod.integration.jei.ModJeiPlugin;

public class CrystalBallCategory
implements IRecipeCategory<RecipeHolder<CrystalBallRecipe>> {
    public static final RecipeType<RecipeHolder<CrystalBallRecipe>> TYPE = RecipeType.createRecipeHolderType((ResourceLocation)Confluence.asResource("crystal_ball"));
    private final IDrawable icon;

    public CrystalBallCategory(IJeiHelpers jeiHelpers) {
        this.icon = jeiHelpers.getGuiHelper().createDrawableItemStack(FunctionalBlocks.CRYSTAL_BALL.toStack());
    }

    public RecipeType<RecipeHolder<CrystalBallRecipe>> getRecipeType() {
        return TYPE;
    }

    public Component getTitle() {
        return Component.translatable((String)"title.confluence.crystal_ball");
    }

    public int getWidth() {
        return 128;
    }

    public int getHeight() {
        return 32;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, RecipeHolder<CrystalBallRecipe> recipe, IFocusGroup focusGroup) {
        ModJeiPlugin.set4IngredientsRecipe(builder, recipe);
    }

    public void createRecipeExtras(IRecipeExtrasBuilder builder, RecipeHolder<CrystalBallRecipe> recipe, IFocusGroup focuses) {
        super.createRecipeExtras(builder, recipe, focuses);
        builder.addRecipeArrow().setPosition(55, 8);
    }

    public void getTooltip(ITooltipBuilder tooltip, RecipeHolder<CrystalBallRecipe> recipe, IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        tooltip.addAll((Collection)((CrystalBallRecipe)recipe.value()).getEnvironment().toDescriptions());
    }

    public ResourceLocation getRegistryName(RecipeHolder<CrystalBallRecipe> recipe) {
        return Confluence.asResource(((CrystalBallRecipe)recipe.value()).getGroup() + "/" + BuiltInRegistries.ITEM.getKey((Object)((CrystalBallRecipe)recipe.value()).getResultItem(null).getItem()).getPath());
    }
}

