/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.integration.jei.category;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import it.unimi.dsi.fastutil.objects.Object2IntLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenCustomHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.ITooltipBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemStackLinkedSet;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import org.confluence.mod.Confluence;
import org.confluence.mod.common.init.ModRecipes;
import org.confluence.mod.common.init.item.MaterialItems;
import org.confluence.mod.common.init.item.PotionItems;

public class BrewingStandTerraPotionCategory
implements IRecipeCategory<Recipe> {
    public static final RecipeType<Recipe> TYPE = RecipeType.create((String)"confluence", (String)"brewing_stand_terra_potion", Recipe.class);
    private static final ResourceLocation BACKGROUND = Confluence.asResource("textures/gui/brewing_stand_terra_potion.png");
    private final IDrawable icon = new IDrawable(this){
        private final ItemStack brewingStand = Items.BREWING_STAND.getDefaultInstance();
        private final ItemStack chaosPotion = PotionItems.CHAOS_POTION.toStack();

        public int getWidth() {
            return 16;
        }

        public int getHeight() {
            return 16;
        }

        public void draw(GuiGraphics guiGraphics, int xOffset, int yOffset) {
            guiGraphics.renderFakeItem(this.brewingStand, xOffset, yOffset);
            PoseStack pose = guiGraphics.pose();
            pose.pushPose();
            pose.translate((float)(xOffset + 8), (float)(yOffset + 8), 100.0f);
            pose.scale(0.5f, 0.5f, 0.5f);
            guiGraphics.renderFakeItem(this.chaosPotion, 0, 0);
            pose.popPose();
        }
    };

    public RecipeType<Recipe> getRecipeType() {
        return TYPE;
    }

    public Component getTitle() {
        return Component.translatable((String)"title.confluence.brewing_stand_terra_potion");
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public int getWidth() {
        return 128;
    }

    public int getHeight() {
        return 64;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, Recipe recipe, IFocusGroup focuses) {
        builder.setShapeless();
        builder.addInputSlot(7, 24).addItemStacks(recipe.input);
        builder.addInputSlot(37, 2).addItemStacks(recipe.ingredient);
        builder.addOutputSlot(101, 24).addItemStack(recipe.output);
    }

    public void getTooltip(ITooltipBuilder tooltip, Recipe recipe, IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        if (mouseY > 45.0) {
            if (mouseX < 64.0) {
                tooltip.add((FormattedText)Component.translatable((String)"tooltip.jei.intermediate_product"));
            }
        } else if (mouseX < 96.0) {
            tooltip.add((FormattedText)Component.translatable((String)"tooltip.jei.brewing_stand_terra_potion"));
        }
    }

    public void draw(Recipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        guiGraphics.blit(BACKGROUND, 0, 0, 0.0f, 0.0f, 128, 64, 128, 64);
    }

    public ResourceLocation getRegistryName(Recipe recipe) {
        return Confluence.asResource("brewing_stand/" + BuiltInRegistries.ITEM.getKey((Object)recipe.output.getItem()).getPath());
    }

    public static final class Recipe {
        public final List<ItemStack> input;
        public final List<ItemStack> ingredient;
        public final ItemStack output;
        public final ResourceLocation id;

        private Recipe(List<ItemStack> input, List<ItemStack> ingredient, ItemStack output, ResourceLocation id) {
            this.input = input;
            this.ingredient = ingredient;
            this.output = output;
            this.id = id;
        }

        public static List<Recipe> getAllRecipes() {
            Object2ObjectLinkedOpenCustomHashMap recipes = new Object2ObjectLinkedOpenCustomHashMap(ItemStackLinkedSet.TYPE_AND_TAG);
            Recipe.add((Map<ItemStack, List<Recipe>>)recipes, PotionItems.BOTTLE.toStack(), List.of(MaterialItems.GEL.toStack(), MaterialItems.LIFE_MUSHROOM.toStack()), PotionItems.LESSER_HEALING_POTION.toStack());
            Recipe.add((Map<ItemStack, List<Recipe>>)recipes, PotionItems.LESSER_HEALING_POTION.toStack(), List.of(PotionItems.LESSER_HEALING_POTION.toStack(), MaterialItems.GLOWING_MUSHROOM.toStack()), PotionItems.HEALING_POTION.toStack());
            Recipe.add((Map<ItemStack, List<Recipe>>)recipes, PotionItems.LESSER_MANA_POTION.toStack(), List.of(PotionItems.LESSER_MANA_POTION.toStack(), MaterialItems.GLOWING_MUSHROOM.toStack()), PotionItems.MANA_POTION.toStack());
            Object2ObjectOpenHashMap id2Item = new Object2ObjectOpenHashMap(ModRecipes.Brewing.MATERIAL_ID_MAP.size());
            for (Object entry : ModRecipes.Brewing.MATERIAL_ID_MAP.object2IntEntrySet()) {
                id2Item.put((Object)entry.getIntValue(), (Object)((Item)entry.getKey()));
            }
            for (Object entry : ModRecipes.Brewing.MATERIAL_TO_RESULT.entrySet()) {
                int[] ids = (int[])entry.getKey();
                Object2IntLinkedOpenHashMap items = new Object2IntLinkedOpenHashMap();
                for (int id : ids) {
                    items.addTo((Object)((Item)id2Item.get((Object)id)), 1);
                }
                ItemStack input = PotionItems.BOTTLED_WATER.toStack();
                List<ItemStack> ingredient = items.object2IntEntrySet().stream().map(e -> new ItemStack((ItemLike)e.getKey(), e.getIntValue())).toList();
                ItemStack output = (ItemStack)entry.getValue();
                Recipe.add((Map<ItemStack, List<Recipe>>)recipes, input, ingredient, output);
            }
            return recipes.values().stream().flatMap(Collection::stream).toList();
        }

        private static void add(Map<ItemStack, List<Recipe>> map, ItemStack input, List<ItemStack> ingredient, ItemStack output) {
            List list = map.computeIfAbsent(output, s -> Lists.newArrayList());
            ResourceLocation id = Confluence.asResource("brewing_stand_terra_potion/" + BuiltInRegistries.ITEM.getKey((Object)output.getItem()).getPath());
            List<ItemStack> stack = List.of(PotionItems.CHAOS_POTION.toStack(), input);
            if (list.isEmpty()) {
                list.add(new Recipe(stack, ingredient, output, id));
            } else {
                list.add(new Recipe(stack, ingredient, output, id.withSuffix("_" + list.size())));
            }
        }
    }
}

