/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.integration.jade;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.Comparator;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.confluence.mod.Confluence;
import org.confluence.mod.common.block.functional.DeathChestBlock;
import org.confluence.mod.common.block.functional.network.INetworkEntity;
import org.confluence.mod.common.block.functional.network.Network;
import org.confluence.mod.common.block.functional.network.NetworkNode;
import org.confluence.terra_curio.client.handler.InformationHandler;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.config.IPluginConfig;

public class NetworkComponentProvider
implements IBlockComponentProvider,
IServerDataProvider<BlockAccessor> {
    public static final NetworkComponentProvider INSTANCE = new NetworkComponentProvider();
    public static final ResourceLocation UID = Confluence.asResource("jade_network_component");

    public void appendTooltip(ITooltip iTooltip, BlockAccessor blockAccessor, IPluginConfig iPluginConfig) {
        if (!blockAccessor.getPlayer().isCreative() && !InformationHandler.hasMechanicalView()) {
            return;
        }
        CompoundTag compoundTag = blockAccessor.getServerData();
        Tag tag2 = compoundTag.get("networkInfo");
        if (tag2 instanceof ListTag) {
            ListTag listTag = (ListTag)tag2;
            listTag.forEach(tag -> {
                if (tag instanceof CompoundTag) {
                    CompoundTag tag1 = (CompoundTag)tag;
                    int color = tag1.getInt("color");
                    Object hexString = Integer.toHexString(color).toUpperCase();
                    hexString = "0".repeat(6 - ((String)hexString).length()) + (String)hexString;
                    iTooltip.add((Component)Component.translatable((String)"info.confluence.network", (Object[])new Object[]{hexString, tag1.getBoolean("signal")}).withStyle(style -> style.withColor(color)));
                }
            });
        }
    }

    public ResourceLocation getUid() {
        return UID;
    }

    public void appendServerData(CompoundTag compoundTag, BlockAccessor blockAccessor) {
        if (!blockAccessor.getPlayer().isCreative() && blockAccessor.getBlock() instanceof DeathChestBlock) {
            return;
        }
        BlockEntity blockEntity = blockAccessor.getBlockEntity();
        if (blockEntity instanceof INetworkEntity) {
            INetworkEntity entity = (INetworkEntity)blockEntity;
            NetworkNode networkNode = entity.getOrCreateNetworkNode();
            ListTag listTag = new ListTag();
            networkNode.getNetworks().int2ObjectEntrySet().stream().sorted(Comparator.comparingInt(Int2ObjectMap.Entry::getIntKey)).forEach(entry -> {
                CompoundTag tag = new CompoundTag();
                tag.putInt("color", entry.getIntKey());
                tag.putBoolean("signal", ((Network)entry.getValue()).hasSignal());
                listTag.add((Object)tag);
            });
            compoundTag.put("networkInfo", (Tag)listTag);
        }
    }
}

