/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.integration.create;

import java.util.function.BiConsumer;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredItem;
import net.neoforged.neoforge.registries.DeferredRegister;
import org.confluence.lib.util.LibUtils;
import org.confluence.lib.util.WipNotDisplayOutput;
import org.confluence.mod.common.init.ModTabs;

public class CreateHelper {
    public static final String MODID = "create";
    public static final boolean IS_LOADED = ModList.get().isLoaded("create");
    public static final DeferredRegister.Items ITEMS = DeferredRegister.createItems((String)"confluence");
    public static final DeferredItem<Item> CRUSHED_RAW_TUNGSTEN = ITEMS.register("crushed_raw_tungsten", () -> new Item(new Item.Properties()));

    public static void register(IEventBus eventBus) {
        if (IS_LOADED) {
            ITEMS.register(eventBus);
            eventBus.addListener(CreateHelper::buildCreativeModeTabContents);
        }
    }

    private static void buildCreativeModeTabContents(BuildCreativeModeTabContentsEvent event) {
        if (event.getTab() == ModTabs.MATERIALS.get()) {
            WipNotDisplayOutput output = new WipNotDisplayOutput((CreativeModeTab.Output)event);
            ITEMS.getEntries().forEach(item -> output.accept((ItemLike)item.get()));
        }
    }

    public static void addTranslateKeys(BiConsumer<DeferredHolder<Item, ? extends Item>, String> consumer, boolean en) {
        if (en) {
            ITEMS.getEntries().forEach(item -> consumer.accept((DeferredHolder<Item, ? extends Item>)item, LibUtils.toTitleCase((String)item.getId().getPath())));
        } else {
            consumer.accept((DeferredHolder<Item, ? extends Item>)CRUSHED_RAW_TUNGSTEN, "\u7c89\u788e\u94a8\u77ff\u77f3");
        }
    }
}

