/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.integration.ars_nouveau;

import com.hollingsworth.arsnouveau.common.capability.ManaCap;
import com.hollingsworth.arsnouveau.setup.config.ServerConfig;
import com.hollingsworth.arsnouveau.setup.registry.CapabilityRegistry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.common.util.TriState;
import org.confluence.mod.api.event.AdditionalManaEvent;
import org.confluence.mod.client.handler.CompatibilityHandler;
import org.confluence.mod.common.CommonConfigs;
import org.confluence.mod.common.attachment.ManaStorage;
import org.confluence.mod.util.PlayerUtils;

public class ArsNouveauHelper {
    public static final String MODID = "ars_nouveau";
    public static final boolean IS_LOADED = ModList.get().isLoaded("ars_nouveau");
    private static final ResourceLocation MANA_BAR_NAME = ResourceLocation.fromNamespaceAndPath((String)"ars_nouveau", (String)"mana_hud");

    public static int getInitMaxMana() {
        return (Integer)ServerConfig.INIT_MAX_MANA.get();
    }

    public static double toConfluence() {
        return 200.0 / (double)ArsNouveauHelper.getInitMaxMana();
    }

    public static void extractMana(ServerPlayer serverPlayer, double manaToRemove) {
        PlayerUtils.extractMana(serverPlayer, ItemStack.EMPTY, () -> (float)(manaToRemove * ArsNouveauHelper.toConfluence()));
    }

    public static TriState enoughMana(LivingEntity living, int totalCost) {
        if (((Boolean)CommonConfigs.CONVERT_ARS_NOUVEAU_MANA.get()).booleanValue() && living instanceof Player) {
            Player player = (Player)living;
            return (double)totalCost * ArsNouveauHelper.toConfluence() <= (double)ManaStorage.of((LivingEntity)player).getCurrentMana() ? TriState.TRUE : TriState.FALSE;
        }
        return TriState.DEFAULT;
    }

    public static boolean cancelRenderManaBar(ResourceLocation name) {
        return IS_LOADED && CompatibilityHandler.isConvertArsNouveauMana() && MANA_BAR_NAME.equals((Object)name);
    }

    public static void additionalMana(AdditionalManaEvent event) {
        if (IS_LOADED) {
            int value = event.getNeoValue();
            ManaCap manaCap = CapabilityRegistry.getMana((LivingEntity)event.getEntity());
            event.setNeoValue(value + (int)((double)(manaCap.getMaxMana() - ArsNouveauHelper.getInitMaxMana()) / ArsNouveauHelper.toConfluence()));
        }
    }

    public static void updateMana(LivingEntity living) {
        if (((Boolean)CommonConfigs.CONVERT_ARS_NOUVEAU_MANA.get()).booleanValue() && living instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)living;
            ManaStorage.of((LivingEntity)player).flushAbility(player);
        }
    }
}

