/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.worldgen.structure;

import com.google.common.collect.Lists;
import com.mojang.serialization.MapCodec;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import org.confluence.lib.common.worldgen.structure.GridPiece;
import org.confluence.lib.util.StructureUtils;
import org.confluence.mod.common.init.ModStructures;
import org.confluence.mod.common.init.block.NatureBlocks;
import org.confluence.mod.common.init.block.OreBlocks;
import org.confluence.mod.common.worldgen.structure.BaseStructures;

public class SmallLivingMahoganyTreeStructure
extends Structure {
    public static final MapCodec<SmallLivingMahoganyTreeStructure> CODEC = SmallLivingMahoganyTreeStructure.simpleCodec(SmallLivingMahoganyTreeStructure::new);

    protected SmallLivingMahoganyTreeStructure(Structure.StructureSettings settings) {
        super(settings);
    }

    protected Optional<Structure.GenerationStub> findGenerationPoint(Structure.GenerationContext context) {
        ChunkPos startChunk = context.chunkPos();
        int x = startChunk.getMiddleBlockX();
        int z = startChunk.getMiddleBlockZ();
        int lowestY = StructureUtils.getHeight((int)x, (int)z, (Structure.GenerationContext)context);
        if (x * x + z * z <= 160000 || lowestY < context.chunkGenerator().getSeaLevel() - 16) {
            return Optional.empty();
        }
        return SmallLivingMahoganyTreeStructure.onTopOfChunkCenter((Structure.GenerationContext)context, (Heightmap.Types)Heightmap.Types.WORLD_SURFACE_WG, builder -> {
            WorldgenRandom random = context.random();
            BlockPos centerPos = startChunk.getMiddleBlockPosition(lowestY);
            Object2IntOpenHashMap blockMap = new Object2IntOpenHashMap();
            BaseStructures.livingTree(centerPos, (Object2IntMap<BlockPos>)blockMap, random, random.nextInt(21, 25), 1, 1.4, 0.8, 1, 7, 2, -7, 1, 1, 1, 1, 3, 1, 5, 3, -10, 1, 1, 1, 1, 3, 1, true, random.nextInt(21, 25), 0, 0.0, 0.0, 0, false, 6.0, 2.0, 8.0, 3.0, 2.0, 1.0, 0.2f, 0.75f, 2, 3);
            GridPiece.addPieces((Object2IntMap)blockMap, (List)Lists.newArrayList((Object[])new BlockState[]{Blocks.AIR.defaultBlockState(), ((RotatedPillarBlock)NatureBlocks.LIVING_MAHOGANY_LOG_BLOCKS.WOOD.get()).defaultBlockState(), (BlockState)((LeavesBlock)NatureBlocks.LIVING_MAHOGANY_LOG_BLOCKS.LEAVES.get()).defaultBlockState().setValue((Property)LeavesBlock.PERSISTENT, (Comparable)Boolean.TRUE), ((Block)OreBlocks.SPORE_ROOT_BLOCK.get()).defaultBlockState()}), (StructurePiecesBuilder)builder);
        });
    }

    public StructureType<?> type() {
        return (StructureType)ModStructures.SMALL_LIVING_MAHOGANY_TREE.get();
    }
}

