/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.worldgen.structure;

import com.google.common.collect.Lists;
import com.mojang.serialization.MapCodec;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import org.confluence.lib.common.worldgen.structure.GridPiece;
import org.confluence.lib.util.StructureUtils;
import org.confluence.mod.common.init.ModStructures;
import org.joml.Vector3d;

public class PyramidStructure
extends Structure {
    public static final MapCodec<PyramidStructure> CODEC = PyramidStructure.simpleCodec(PyramidStructure::new);

    protected PyramidStructure(Structure.StructureSettings settings) {
        super(settings);
    }

    protected Optional<Structure.GenerationStub> findGenerationPoint(Structure.GenerationContext context) {
        ChunkPos startChunk = context.chunkPos();
        int x = startChunk.getMiddleBlockX();
        int z = startChunk.getMiddleBlockZ();
        int lowestY = StructureUtils.getHeight((int)x, (int)z, (Structure.GenerationContext)context);
        if (x * x + z * z <= 160000 || lowestY < context.chunkGenerator().getSeaLevel() - 16) {
            return Optional.empty();
        }
        return PyramidStructure.onTopOfChunkCenter((Structure.GenerationContext)context, (Heightmap.Types)Heightmap.Types.WORLD_SURFACE_WG, builder -> {
            WorldgenRandom random = context.random();
            BlockPos centerPos = startChunk.getMiddleBlockPosition(lowestY).offset(0, 1, 0);
            Object2IntOpenHashMap blockMap = new Object2IntOpenHashMap();
            StructureUtils.pyramidSet((BlockPos)centerPos, (int)1, (int)120, (Object2IntMap)blockMap);
            for (int i = 0; i < 8; ++i) {
                StructureUtils.mazeSet((BlockPos)centerPos.offset(0, 1 + 10 * i, 0), (double)10.0, (int)(10 - i), (int)0, (int)3, (int)8, (WorldgenRandom)random, (float)1.0f, (Object2IntMap)blockMap);
            }
            StructureUtils.frustumSet((Vector3d)new Vector3d((double)centerPos.getX(), (double)(centerPos.getY() + 1), (double)centerPos.getZ()), (Vector3d)new Vector3d((double)centerPos.getX(), (double)centerPos.getY() + 82.5, (double)centerPos.getZ()), (double)23.5, (double)23.5, (int)0, (Object2IntMap)blockMap);
            StructureUtils.frustumSet((Vector3d)new Vector3d((double)centerPos.getX(), (double)(centerPos.getY() + 81), (double)centerPos.getZ()), (Vector3d)new Vector3d((double)centerPos.getX(), (double)centerPos.getY() + 92.5, (double)centerPos.getZ()), (double)4.5, (double)4.5, (int)0, (Object2IntMap)blockMap);
            StructureUtils.pyramidSet((BlockPos)centerPos.offset(0, 90, 0), (int)0, (int)23, (Object2IntMap)blockMap);
            GridPiece.addPieces((Object2IntMap)blockMap, (List)Lists.newArrayList((Object[])new BlockState[]{Blocks.AIR.defaultBlockState(), Blocks.SANDSTONE.defaultBlockState()}), (StructurePiecesBuilder)builder);
        });
    }

    public StructureType<?> type() {
        return (StructureType)ModStructures.PYRAMID.get();
    }
}

