/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.worldgen.secret_seed;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.confluence.lib.util.LibUtils;
import org.confluence.mod.Confluence;
import org.confluence.mod.common.init.ModDamageTypes;
import org.confluence.mod.common.init.ModEffects;
import org.confluence.mod.common.init.ModSecretSeeds;
import org.confluence.mod.common.init.ModTags;
import org.confluence.mod.common.worldgen.secret_seed.SecretSeed;
import org.jetbrains.annotations.Nullable;

public class TheConstant
extends SecretSeed {
    public static final ResourceLocation POST_EFFECT = Confluence.asResource("shaders/post/the_constant.json");

    public TheConstant(long flag, ResourceLocation id) {
        super(flag, id);
    }

    @Override
    public boolean match(String seed) {
        return "constant".equals(seed) || "theconstant".equals(seed) || "the constant".equals(seed) || "eye4aneye".equals(seed) || "eyeforaneye".equals(seed);
    }

    public static float applyAttackDamage(@Nullable Entity causer, float amount) {
        ServerPlayer serverPlayer;
        if (causer instanceof ServerPlayer && (serverPlayer = (ServerPlayer)causer).getFoodData().needsFood() && ModSecretSeeds.THE_CONSTANT.match(serverPlayer.server)) {
            return amount * 0.8f;
        }
        return amount;
    }

    public static void applyDarkness(ServerPlayer player, ServerLevel level, long gameTime) {
        if (player.gameMode.getGameModeForPlayer().isSurvival() && gameTime % 20L == 0L && ModSecretSeeds.THE_CONSTANT.match(level)) {
            int brightness;
            if (player.hasEffect(ModEffects.SHINE) || player.hasEffect(MobEffects.GLOWING)) {
                return;
            }
            if (LibUtils.anyHandHasItem((LivingEntity)player, ModTags.Items.PROVIDE_LIGHT)) {
                return;
            }
            CompoundTag data = LibUtils.getOrCreatePersistedData((Player)player);
            int tick = data.getInt("confluence:in_darkness_tick");
            BlockPos eyePos = BlockPos.containing((Position)player.getEyePosition());
            int n = brightness = level.getLevel().isThundering() ? level.getMaxLocalRawBrightness(eyePos, 10) : level.getMaxLocalRawBrightness(eyePos);
            if (brightness <= 5) {
                if (tick < 5) {
                    if (++tick == 3) {
                        player.sendSystemMessage((Component)Component.translatable((String)"secret_seed.the_constant.in_darkness_for_3_second"), false);
                    }
                    data.putInt("confluence:in_darkness_tick", tick);
                } else {
                    player.hurt(ModDamageTypes.of((Level)level, ModDamageTypes.DARKNESS), 50.0f);
                }
            } else if (tick != 0) {
                data.putInt("confluence:in_darkness_tick", 0);
            }
        }
    }
}

