/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.worldgen.secret_seed;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.confluence.lib.util.VectorUtils;
import org.confluence.mod.common.entity.projectile.bomb.BaseBombEntity;
import org.confluence.mod.common.entity.projectile.bomb.BaseGrenadeEntity;
import org.confluence.mod.common.init.ModEntities;
import org.confluence.mod.common.init.ModSecretSeeds;
import org.confluence.mod.common.init.item.ConsumableItems;
import org.confluence.mod.common.item.common.ThrowableItem;
import org.confluence.mod.common.worldgen.secret_seed.SecretSeed;

public class NoTraps
extends SecretSeed {
    public NoTraps(long flag, ResourceLocation id) {
        super(flag, id);
    }

    @Override
    public boolean match(String seed) {
        return "notraps".equals(seed) || "no traps".equals(seed);
    }

    public static void dropBombWhenLeavesDestroy(ServerPlayer serverPlayer, BlockState blockState, BlockPos pos) {
        if (!(!blockState.is(BlockTags.LEAVES) || blockState.hasProperty((Property)BlockStateProperties.PERSISTENT) && ((Boolean)blockState.getValue((Property)BlockStateProperties.PERSISTENT)).booleanValue())) {
            ServerLevel level = serverPlayer.serverLevel();
            if (ModSecretSeeds.FOR_THE_WORTHY.match(serverPlayer.server) && blockState.is(BlockTags.LEAVES) && level.random.nextFloat() < 0.25f) {
                BaseBombEntity bomb = new BaseBombEntity((EntityType<? extends BaseBombEntity>)((EntityType)ModEntities.BOMB_ENTITY.get()), (Level)level);
                bomb.setPos(pos.getCenter());
                level.addFreshEntity((Entity)bomb);
            }
        }
    }

    public static void breakClimbable(LivingEntity living) {
        if (living instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)living;
            if (ModSecretSeeds.NO_TRAPS.match(serverPlayer.server) && living.level().getGameTime() % 20L == 0L && living.getRandom().nextFloat() < 0.3f) {
                living.level().destroyBlock(living.blockPosition(), true);
            }
        }
    }

    public static void entityInvulnerableToExplosion(Level level, List<Entity> affectedEntities) {
        ServerLevel serverLevel;
        if (level instanceof ServerLevel && ModSecretSeeds.NO_TRAPS.match(serverLevel = (ServerLevel)level)) {
            affectedEntities.removeIf(entity -> !(entity instanceof ServerPlayer));
        }
    }

    public static void entityDropsGrenade(LivingEntity living) {
        Player nearestPlayer;
        ServerLevel serverLevel;
        Level level = living.level();
        if (level instanceof ServerLevel && ModSecretSeeds.NO_TRAPS.match(serverLevel = (ServerLevel)level) && living.getRandom().nextFloat() < 0.03f && (nearestPlayer = serverLevel.getNearestPlayer((Entity)living, 16.0)) != null) {
            BaseGrenadeEntity grenade = new BaseGrenadeEntity(living);
            grenade.setItem(((ThrowableItem)((Object)ConsumableItems.GRENADE.get())).getDefaultInstance());
            Vec3 vectorA2B = VectorUtils.getVectorA2B((Entity)living, (Entity)nearestPlayer);
            double size = living.getBoundingBox().getSize() + 1.5;
            grenade.moveTo(living.position().add(vectorA2B.x * size, vectorA2B.y * size + 0.5, vectorA2B.z * size));
            float[] rots = VectorUtils.dirToRot((Vec3)vectorA2B, (boolean)true);
            grenade.shootFromRotation((Entity)living, rots[1], rots[0], 0.0f, living.distanceTo((Entity)nearestPlayer) / 4.0f, 0.0f);
            serverLevel.addFreshEntity((Entity)grenade);
        }
    }
}

