/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.worldgen.feature;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import org.confluence.lib.util.FeatureUtils;

public class SimpleBlockNBTFeature
extends Feature<Config> {
    public SimpleBlockNBTFeature(Codec<Config> pCodec) {
        super(pCodec);
    }

    public boolean place(FeaturePlaceContext<Config> pContext) {
        Config config = (Config)pContext.config();
        WorldGenLevel level = pContext.level();
        BlockPos blockPos = pContext.origin();
        BlockState blockState = config.toPlace().getState(pContext.random(), blockPos);
        if (blockState.canSurvive((LevelReader)level, blockPos)) {
            level.setBlock(blockPos, blockState, 3);
            BlockEntity blockEntity = FeatureUtils.getBlockEntity((WorldGenLevel)level, (BlockPos)blockPos);
            if (blockEntity != null) {
                blockEntity.loadWithComponents(config.nbt, (HolderLookup.Provider)level.registryAccess());
            }
            return true;
        }
        return false;
    }

    public record Config(BlockStateProvider toPlace, CompoundTag nbt) implements FeatureConfiguration
    {
        public static final Codec<Config> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BlockStateProvider.CODEC.fieldOf("to_place").forGetter(Config::toPlace), (App)CompoundTag.CODEC.fieldOf("nbt").forGetter(Config::nbt)).apply((Applicative)instance, Config::new));

        public Config(BlockStateProvider toPlace, Consumer<CompoundTag> consumer) {
            this(toPlace, Config.tag(consumer));
        }

        private static CompoundTag tag(Consumer<CompoundTag> consumer) {
            CompoundTag tag = new CompoundTag();
            consumer.accept(tag);
            return tag;
        }
    }
}

