/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.worldgen.feature;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import org.confluence.lib.common.block.StateProperties;
import org.confluence.mod.common.block.functional.SignalAdapterBlock;
import org.confluence.mod.common.block.functional.network.INetworkEntity;
import org.confluence.mod.common.init.ModFeatures;
import org.confluence.mod.common.init.block.FunctionalBlocks;

public class RailTrapFeature
extends Feature<Config> {
    public RailTrapFeature(Codec<Config> pCodec) {
        super(pCodec);
    }

    public boolean place(FeaturePlaceContext<Config> pContext) {
        Config config = (Config)pContext.config();
        WorldGenLevel level = pContext.level();
        BlockPos centerPos = pContext.origin();
        BlockState trapBlockState = config.trap().getState(pContext.random(), centerPos);
        BlockState signalBlockState = (BlockState)((SignalAdapterBlock)FunctionalBlocks.SIGNAL_ADAPTER.get()).defaultBlockState().setValue((Property)StateProperties.REVERSE, (Comparable)Boolean.TRUE);
        boolean place = true;
        ArrayList<BlockPos> trapList = new ArrayList<BlockPos>();
        ArrayList<BlockPos> trapListTrue = new ArrayList<BlockPos>();
        trapList.add(centerPos.offset(1, 1, 1));
        trapList.add(centerPos.offset(0, 1, 1));
        trapList.add(centerPos.offset(-1, 1, 1));
        trapList.add(centerPos.offset(1, 1, 0));
        trapList.add(centerPos.offset(0, 1, 0));
        trapList.add(centerPos.offset(-1, 1, 0));
        trapList.add(centerPos.offset(1, 1, -1));
        trapList.add(centerPos.offset(0, 1, -1));
        trapList.add(centerPos.offset(-1, 1, -1));
        INetworkEntity trapEntity = null;
        INetworkEntity signalEntity = null;
        block0: for (BlockPos trap : trapList) {
            for (int i = 0; i < 100; ++i) {
                BlockPos checkPos = trap.offset(0, i, 0);
                if (level.getBlockState(checkPos).canBeReplaced()) continue;
                trapListTrue.add(trap.offset(0, i, 0));
                continue block0;
            }
        }
        if (!trapListTrue.isEmpty()) {
            level.setBlock(centerPos.offset(0, -1, 0), signalBlockState, 3);
            for (BlockPos trap : trapListTrue) {
                level.setBlock(trap, trapBlockState, 3);
                trapEntity = ModFeatures.getNetworkEntity(level, trap);
                signalEntity = ModFeatures.getNetworkEntity(level, centerPos.offset(0, -1, 0));
                if (trapEntity == null || signalEntity == null) continue;
                trapEntity.connectTo(0xFF00FF, centerPos.offset(0, -1, 0), signalEntity);
            }
            return true;
        }
        return false;
    }

    public record Config(BlockStateProvider trap) implements FeatureConfiguration
    {
        public static final Codec<Config> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BlockStateProvider.CODEC.fieldOf("trap").forGetter(Config::trap)).apply((Applicative)instance, Config::new));
    }
}

