/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.worldgen.feature;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.HashSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.TreeFeature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import org.confluence.lib.util.FeatureUtils;

public class DroopingVineTreeFeature
extends Feature<Config> {
    public DroopingVineTreeFeature(Codec<Config> pCodec) {
        super(pCodec);
    }

    private static void setLeaves(BoundingBox box, BlockState leaves, boolean up, RandomSource random, WorldGenLevel level) {
        FeatureUtils.leaves((BoundingBox)box, (BlockState)leaves, (boolean)up, (RandomSource)random, (WorldGenLevel)level, (BlockState)Blocks.AIR.defaultBlockState(), (boolean)false);
    }

    private static void setLeaves(BoundingBox box, BlockState leaves, boolean up, RandomSource random, WorldGenLevel level, BlockState droopingLeaves) {
        FeatureUtils.leaves((BoundingBox)box, (BlockState)leaves, (boolean)up, (RandomSource)random, (WorldGenLevel)level, (BlockState)droopingLeaves, (boolean)true);
    }

    public boolean place(FeaturePlaceContext<Config> pContext) {
        int i;
        RandomSource random = pContext.random();
        Config config = (Config)pContext.config();
        WorldGenLevel level = pContext.level();
        BlockPos baseBlockPos = pContext.origin();
        BlockState trunkBlockState = config.trunk().getState(random, baseBlockPos);
        BlockState leavesBlockState = config.leaves().getState(random, baseBlockPos);
        BlockState droopingLeavesBlockState = config.drooping_leaves.getState(random, baseBlockPos);
        int height = config.height + random.nextInt(3);
        ArrayList<BlockPos> trunkPosList = new ArrayList<BlockPos>();
        HashSet trunkPos = new HashSet();
        HashSet leavesPos = new HashSet();
        HashSet<BlockPos> rootPos = new HashSet<BlockPos>();
        BoundingBox box = new BoundingBox(baseBlockPos.getX() - 2, baseBlockPos.getY(), baseBlockPos.getZ() - 2, baseBlockPos.getX() + 2, baseBlockPos.getY() + height + 4, baseBlockPos.getZ() + 2);
        for (int i2 = 0; i2 < height + 3; ++i2) {
            trunkPosList.add(baseBlockPos.offset(0, i2, 0));
        }
        boolean placed = true;
        for (i = 0; i < trunkPosList.size(); ++i) {
            if (level.getBlockState((BlockPos)trunkPosList.get(i)).isAir() || level.getBlockState((BlockPos)trunkPosList.get(i)).is(TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"leaves")))) continue;
            placed = false;
        }
        if (placed) {
            for (i = 0; i < trunkPosList.size(); ++i) {
                level.setBlock((BlockPos)trunkPosList.get(i), trunkBlockState, 3);
                rootPos.add((BlockPos)trunkPosList.get(i));
            }
            DroopingVineTreeFeature.setLeaves(new BoundingBox(baseBlockPos.getX() - 2, baseBlockPos.getY() + height, baseBlockPos.getZ() - 2, baseBlockPos.getX() + 2, baseBlockPos.getY() + height + 1, baseBlockPos.getZ() + 2), leavesBlockState, true, random, level, droopingLeavesBlockState);
            DroopingVineTreeFeature.setLeaves(new BoundingBox(baseBlockPos.getX() - 1, baseBlockPos.getY() + height + 2, baseBlockPos.getZ() - 1, baseBlockPos.getX() + 1, baseBlockPos.getY() + height + 3, baseBlockPos.getZ() + 1), leavesBlockState, false, random, level);
            TreeFeature.updateLeaves((LevelAccessor)level, (BoundingBox)box, rootPos, trunkPos, leavesPos);
            return true;
        }
        return false;
    }

    public record Config(BlockStateProvider trunk, BlockStateProvider leaves, BlockStateProvider drooping_leaves, int height) implements FeatureConfiguration
    {
        public static final Codec<Config> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BlockStateProvider.CODEC.fieldOf("trunk_block").forGetter(Config::trunk), (App)BlockStateProvider.CODEC.fieldOf("leaves_block").forGetter(Config::leaves), (App)BlockStateProvider.CODEC.fieldOf("drooping_vine_block").forGetter(Config::drooping_leaves), (App)Codec.INT.fieldOf("height").forGetter(Config::height)).apply((Applicative)instance, Config::new));
    }
}

