/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.worldgen.feature;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import org.confluence.lib.util.FeatureUtils;
import org.confluence.mod.common.block.common.BaseRopeBlock;

public class DroopingBlockFeature
extends Feature<Config> {
    public DroopingBlockFeature(Codec<Config> pCodec) {
        super(pCodec);
    }

    private static void setLeaves(BoundingBox box, BlockState leaves, boolean up, RandomSource random, WorldGenLevel level) {
        FeatureUtils.leaves((BoundingBox)box, (BlockState)leaves, (boolean)up, (RandomSource)random, (WorldGenLevel)level, (BlockState)Blocks.AIR.defaultBlockState(), (boolean)false);
    }

    private static void setLeaves(BoundingBox box, BlockState leaves, boolean up, RandomSource random, WorldGenLevel level, BlockState droopingLeaves) {
        FeatureUtils.leaves((BoundingBox)box, (BlockState)leaves, (boolean)up, (RandomSource)random, (WorldGenLevel)level, (BlockState)droopingLeaves, (boolean)true);
    }

    public boolean place(FeaturePlaceContext<Config> context) {
        boolean placed;
        int minY;
        RandomSource random = context.random();
        Config config = (Config)context.config();
        WorldGenLevel level = context.level();
        BlockPos baseBlockPos = context.origin();
        BlockState droopingBlockBlockState = config.droopingBlock.getState(random, baseBlockPos);
        int height = config.height + random.nextInt(config.extraHeight + 1);
        int endY = minY = level.getMinBuildHeight();
        boolean toGround = config.toGround;
        boolean bl = placed = level.getBlockState(baseBlockPos).canBeReplaced() && baseBlockPos.getY() > -63;
        if (placed) {
            if (toGround) {
                int yCheck = 0;
                while (baseBlockPos.getY() + yCheck >= minY) {
                    boolean down;
                    endY = baseBlockPos.getY() + yCheck;
                    if (down = level.getBlockState(baseBlockPos.offset(0, --yCheck, 0)).canBeReplaced()) continue;
                    break;
                }
            } else {
                for (int yCheck = 0; yCheck < height && baseBlockPos.getY() - yCheck >= minY && level.getBlockState(baseBlockPos.offset(0, -yCheck, 0)).canBeReplaced(); ++yCheck) {
                    endY = baseBlockPos.getY() - yCheck;
                }
            }
        }
        if (placed) {
            for (int i = endY; i <= baseBlockPos.getY(); ++i) {
                BlockState toPlace = level.getBlockState(baseBlockPos.offset(0, -baseBlockPos.getY() + i, 0));
                level.setBlock(baseBlockPos.offset(0, -baseBlockPos.getY() + i, 0), toPlace.is(Blocks.WATER) || toPlace == toPlace.trySetValue((Property)BaseRopeBlock.WATERLOGGED, (Comparable)Boolean.valueOf(true)) && toPlace.hasProperty((Property)BaseRopeBlock.WATERLOGGED) ? (BlockState)droopingBlockBlockState.trySetValue((Property)BaseRopeBlock.WATERLOGGED, (Comparable)Boolean.valueOf(true)) : droopingBlockBlockState, 3);
            }
            return true;
        }
        return false;
    }

    public record Config(BlockStateProvider droopingBlock, boolean toGround, int height, int extraHeight) implements FeatureConfiguration
    {
        public static final Codec<Config> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BlockStateProvider.CODEC.fieldOf("drooping_block").forGetter(Config::droopingBlock), (App)Codec.BOOL.fieldOf("to_ground").forGetter(Config::toGround), (App)Codec.INT.fieldOf("height").forGetter(Config::height), (App)Codec.INT.fieldOf("extra_height").forGetter(Config::extraHeight)).apply((Applicative)instance, Config::new));
    }
}

