/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.worldgen.feature;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.RandomSource;
import net.minecraft.world.RandomizableContainer;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.Column;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.storage.loot.LootTable;
import org.confluence.lib.util.FeatureUtils;
import org.confluence.lib.util.LibUtils;
import org.confluence.mod.common.block.common.BaseChestBlock;
import org.confluence.mod.common.block.functional.InstantExplosionBlock;
import org.confluence.mod.common.block.functional.boulder.AbstractBoulderBlock;
import org.confluence.mod.common.block.functional.network.INetworkEntity;
import org.confluence.mod.common.init.ModFeatures;
import org.confluence.mod.common.init.ModLootTables;
import org.confluence.mod.common.init.ModSecretSeeds;
import org.confluence.mod.common.init.block.ChestBlocks;
import org.confluence.mod.common.init.block.FunctionalBlocks;

public class DeathChestTrapFeature
extends Feature<Config> {
    public DeathChestTrapFeature(Codec<Config> pCodec) {
        super(pCodec);
    }

    public boolean place(FeaturePlaceContext<Config> pContext) {
        Block deathChest;
        BlockState chestState;
        Config config = (Config)pContext.config();
        WorldGenLevel level = pContext.level();
        RandomSource random = pContext.random();
        BlockPos blockPos = pContext.origin();
        if (!FeatureUtils.isPosAir((WorldGenLevel)level, (BlockPos)blockPos)) {
            return false;
        }
        BlockPos.MutableBlockPos mutablePos = blockPos.mutable();
        for (int v = 1; v <= config.maxSearchDown && FeatureUtils.isPosAir((WorldGenLevel)level, (BlockPos)mutablePos); ++v) {
            mutablePos.move(0, -1, 0);
        }
        if (level.isStateAtPosition((BlockPos)mutablePos, BlockBehaviour.BlockStateBase::liquid)) {
            return false;
        }
        BlockPos chestPos = mutablePos.above();
        if (FeatureUtils.safeSetBlock((WorldGenLevel)level, (BlockPos)chestPos, (BlockState)(chestState = StructurePiece.reorient((BlockGetter)level, (BlockPos)chestPos, (BlockState)((BlockState)(deathChest = ModSecretSeeds.NO_TRAPS.match(level.getLevel().getServer()) && random.nextBoolean() ? (Block)ChestBlocks.DEATH_WOODEN_CHEST.get() : (Block)ChestBlocks.DEATH_GOLDEN_CHEST.get()).defaultBlockState().setValue((Property)BaseChestBlock.UNLOCKED, (Comparable)Boolean.valueOf(true))))), ModFeatures.IS_REPLACEABLE)) {
            RandomizableContainer.setBlockEntityLootTable((BlockGetter)level, (RandomSource)random, (BlockPos)chestPos, config.lootTable);
            INetworkEntity chest = ModFeatures.getNetworkEntity(level, chestPos);
            if (chest != null && chest.getSelf() instanceof BaseChestBlock.BEntity) {
                boolean b = DeathChestTrapFeature.placeDartTraps(config, level, chestPos, chest);
                boolean b1 = DeathChestTrapFeature.placeBoulders(config, random, level, chestPos, chest);
                boolean b2 = DeathChestTrapFeature.placeTNTs(config, random, level, chestPos, chest);
                return b || b1 || b2;
            }
        }
        return false;
    }

    private static boolean placeTNTs(Config config, RandomSource random, WorldGenLevel level, BlockPos chestPos, INetworkEntity chest) {
        boolean succeed = false;
        BlockState blockState = ((InstantExplosionBlock)FunctionalBlocks.INSTANTANEOUS_EXPLOSION_TNT.get()).defaultBlockState();
        int amount = config.tntAmount;
        int half = amount / 2;
        for (BlockPos pos : BlockPos.randomBetweenClosed((RandomSource)random, (int)amount, (int)(chestPos.getX() - half), (int)(chestPos.getY() - 3), (int)(chestPos.getZ() - half), (int)(chestPos.getX() + half), (int)(chestPos.getY() - 2), (int)(chestPos.getZ() + half))) {
            INetworkEntity tnt;
            BlockPos.MutableBlockPos mutable = pos.mutable();
            for (Direction direction : LibUtils.DIRECTIONS) {
                if (direction == Direction.UP || !level.isStateAtPosition(pos.relative(direction), BlockBehaviour.BlockStateBase::isAir)) continue;
                mutable.move(direction.getOpposite());
            }
            if (!FeatureUtils.safeSetBlock((WorldGenLevel)level, (BlockPos)mutable, (BlockState)blockState, ModFeatures.IS_REPLACEABLE) || (tnt = ModFeatures.getNetworkEntity(level, (BlockPos)mutable)) == null) continue;
            tnt.connectTo(255, chestPos, chest);
            succeed = true;
        }
        return succeed;
    }

    private static boolean placeBoulders(Config config, RandomSource random, WorldGenLevel level, BlockPos chestPos, INetworkEntity chest) {
        boolean succeed = false;
        int maxBoulderHeight = config.maxBoulderHeight;
        int amount = config.boulderAmount;
        int half = amount / 2;
        for (BlockPos pos : BlockPos.randomBetweenClosed((RandomSource)random, (int)amount, (int)(chestPos.getX() - half), (int)chestPos.getY(), (int)(chestPos.getZ() - half), (int)(chestPos.getX() + half), (int)chestPos.getY(), (int)(chestPos.getZ() + half))) {
            INetworkEntity boulder;
            BlockPos boulderPos;
            Column.Range range;
            Object t;
            Optional optionalColumn = Column.scan((LevelSimulatedReader)level, (BlockPos)pos, (int)maxBoulderHeight, BlockBehaviour.BlockStateBase::isAir, ModFeatures.IS_BASE_STONE);
            if (!optionalColumn.isPresent() || !((t = optionalColumn.get()) instanceof Column.Range) || (range = (Column.Range)t).height() <= 4 || !FeatureUtils.safeSetBlock((WorldGenLevel)level, (BlockPos)(boulderPos = pos.atY(range.ceiling())), (BlockState)ModFeatures.getBoulder(level, random, config.boulder), ModFeatures.IS_REPLACEABLE) || (boulder = ModFeatures.getNetworkEntity(level, boulderPos)) == null) continue;
            boulder.connectTo(0xFF0000, chestPos, chest);
            succeed = true;
        }
        return succeed;
    }

    private static boolean placeDartTraps(Config config, WorldGenLevel level, BlockPos chestPos, INetworkEntity chest) {
        boolean succeed = false;
        int maxDartDistance = config.maxDartDistance;
        block0: for (Direction direction : LibUtils.HORIZONTAL) {
            BlockPos.MutableBlockPos copy = chestPos.mutable();
            Direction opposite = direction.getOpposite();
            BlockPos.MutableBlockPos firstFindPos = null;
            INetworkEntity firstFind = null;
            Direction right = direction.getClockWise();
            Direction left = right.getOpposite();
            BlockPos rightBottom = copy.relative(right);
            BlockPos leftTop = copy.above(2).relative(left);
            for (BlockPos pos : BlockPos.betweenClosed((BlockPos)leftTop, (BlockPos)rightBottom)) {
                INetworkEntity connectEntity;
                BlockPos.MutableBlockPos connectPos;
                int h;
                BlockPos.MutableBlockPos mutable = pos.mutable().move(direction);
                for (h = 1; h <= maxDartDistance && FeatureUtils.ensureCanWrite((WorldGenLevel)level, (BlockPos)mutable) && FeatureUtils.isPosAir((WorldGenLevel)level, (BlockPos)mutable); ++h) {
                    mutable.move(direction);
                }
                if (!FeatureUtils.ensureCanWrite((WorldGenLevel)level, (BlockPos)mutable) || h < 16 || level.isStateAtPosition((BlockPos)mutable, blockState -> blockState.isAir() || blockState.getCollisionShape((BlockGetter)level, (BlockPos)mutable).isEmpty())) continue;
                BlockState dartTrap = ModFeatures.getDartTrap(level, (BlockPos)mutable, opposite);
                if (!FeatureUtils.safeSetBlock((WorldGenLevel)level, (BlockPos)mutable, (BlockState)dartTrap, ModFeatures.IS_REPLACEABLE)) continue block0;
                INetworkEntity dart = ModFeatures.getNetworkEntity(level, (BlockPos)mutable);
                if (firstFindPos == null) {
                    firstFindPos = mutable;
                    connectPos = chestPos;
                } else {
                    connectPos = firstFindPos;
                }
                if (firstFind == null) {
                    firstFind = dart;
                    connectEntity = chest;
                } else {
                    connectEntity = firstFind;
                }
                if (dart == null) continue;
                dart.connectTo(65280, (BlockPos)connectPos, connectEntity);
                succeed = true;
            }
        }
        return succeed;
    }

    public record Config(int maxDartDistance, BlockState boulder, int boulderAmount, int maxBoulderHeight, int tntAmount, int maxSearchDown, ResourceKey<LootTable> lootTable) implements FeatureConfiguration
    {
        public static final Codec<Config> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ExtraCodecs.POSITIVE_INT.lenientOptionalFieldOf("max_dart_distance", (Object)24).forGetter(Config::maxDartDistance), (App)BlockState.CODEC.fieldOf("boulder").orElseGet(() -> ((AbstractBoulderBlock)FunctionalBlocks.NORMAL_BOULDER.get()).defaultBlockState()).forGetter(Config::boulder), (App)ExtraCodecs.POSITIVE_INT.lenientOptionalFieldOf("boulder_amount", (Object)5).forGetter(Config::boulderAmount), (App)ExtraCodecs.POSITIVE_INT.lenientOptionalFieldOf("max_boulder_height", (Object)64).forGetter(Config::maxBoulderHeight), (App)ExtraCodecs.POSITIVE_INT.lenientOptionalFieldOf("tnt_amount", (Object)3).forGetter(Config::tntAmount), (App)ExtraCodecs.POSITIVE_INT.lenientOptionalFieldOf("max_search_down", (Object)32).forGetter(Config::maxSearchDown), (App)ResourceKey.codec((ResourceKey)Registries.LOOT_TABLE).lenientOptionalFieldOf("loot_table", ModLootTables.CAVE_CHESTS).forGetter(Config::lootTable)).apply((Applicative)instance, Config::new));
    }
}

