/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.worldgen.feature;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.Tuple;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import org.confluence.lib.util.FeatureUtils;
import org.confluence.lib.util.LibUtils;
import org.confluence.mod.common.block.functional.network.INetworkEntity;
import org.confluence.mod.common.init.ModFeatures;

public class DartTrapFeature
extends Feature<Config> {
    public DartTrapFeature(Codec<Config> pCodec) {
        super(pCodec);
    }

    public boolean place(FeaturePlaceContext<Config> pContext) {
        BlockPos blockPos;
        Config config = (Config)pContext.config();
        WorldGenLevel level = pContext.level();
        if (!FeatureUtils.isPosAir((WorldGenLevel)level, (BlockPos)(blockPos = pContext.origin()))) {
            return false;
        }
        BlockPos.MutableBlockPos mutablePos = blockPos.mutable();
        for (int v = 1; v <= config.maxSearchDown && FeatureUtils.isPosAir((WorldGenLevel)level, (BlockPos)mutablePos); ++v) {
            mutablePos.move(0, -1, 0);
        }
        if (FeatureUtils.isPosSturdy((WorldGenLevel)level, (BlockPos)mutablePos, (Direction)Direction.UP)) {
            BlockPos dartPos = mutablePos.offset(0, 2, 0);
            for (Direction direction : LibUtils.HORIZONTAL) {
                int h;
                BlockPos.MutableBlockPos copy = dartPos.mutable();
                for (h = 1; h <= config.maxDartDistance && FeatureUtils.ensureCanWrite((WorldGenLevel)level, (BlockPos)copy) && FeatureUtils.isPosAir((WorldGenLevel)level, (BlockPos)copy); ++h) {
                    copy.move(direction);
                }
                if (!FeatureUtils.ensureCanWrite((WorldGenLevel)level, (BlockPos)copy) || h < 4 || level.isStateAtPosition((BlockPos)copy, blockState -> blockState.isAir() || blockState.getCollisionShape((BlockGetter)level, (BlockPos)copy).isEmpty())) continue;
                BlockState dartTrap = ModFeatures.getDartTrap(level, (BlockPos)copy, direction.getOpposite());
                boolean b = FeatureUtils.safeSetBlock((WorldGenLevel)level, (BlockPos)copy, (BlockState)dartTrap, ModFeatures.IS_REPLACEABLE);
                Tuple<BlockPos, BlockState> pressurePlate = ModFeatures.getPressurePlate(level, (BlockPos)mutablePos);
                BlockPos platePos = (BlockPos)pressurePlate.getA();
                boolean b1 = FeatureUtils.safeSetBlock((WorldGenLevel)level, (BlockPos)platePos, (BlockState)((BlockState)pressurePlate.getB()), ModFeatures.IS_REPLACEABLE);
                if (!b || !b1) continue;
                INetworkEntity dart = ModFeatures.getNetworkEntity(level, (BlockPos)copy);
                INetworkEntity plate = ModFeatures.getNetworkEntity(level, platePos);
                if (dart != null && plate != null) {
                    dart.connectTo(65280, platePos, plate);
                }
                return true;
            }
        }
        return false;
    }

    public record Config(int maxDartDistance, int maxSearchDown) implements FeatureConfiguration
    {
        public static final Codec<Config> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ExtraCodecs.POSITIVE_INT.lenientOptionalFieldOf("max_dart_distance", (Object)24).forGetter(Config::maxDartDistance), (App)ExtraCodecs.POSITIVE_INT.lenientOptionalFieldOf("max_search_down", (Object)32).forGetter(Config::maxSearchDown)).apply((Applicative)instance, Config::new));
    }
}

