/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.worldgen.biome;

import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.SurfaceRules;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.placement.CaveSurface;
import org.confluence.mod.common.init.ModBiomes;
import org.confluence.mod.common.init.block.NatureBlocks;

public class SurfaceRuleData {
    private static final SurfaceRules.RuleSource DIRT = SurfaceRuleData.makeStateRule(Blocks.DIRT);
    private static final SurfaceRules.RuleSource SNOW = SurfaceRuleData.makeStateRule(Blocks.SNOW_BLOCK);
    private static final SurfaceRules.RuleSource PACKED_ICE = SurfaceRuleData.makeStateRule(Blocks.PACKED_ICE);
    private static final SurfaceRules.RuleSource SAND = SurfaceRuleData.makeStateRule(Blocks.SAND);
    private static final SurfaceRules.RuleSource RED_SAND = SurfaceRuleData.makeStateRule(Blocks.RED_SAND);
    private static final SurfaceRules.RuleSource GRAVEL = SurfaceRuleData.makeStateRule(Blocks.GRAVEL);
    private static final SurfaceRules.RuleSource SANDSTONE = SurfaceRuleData.makeStateRule(Blocks.SANDSTONE);
    private static final SurfaceRules.RuleSource HARDENED_SAND = SurfaceRuleData.makeStateRule((Block)NatureBlocks.HARDENED_SAND_BLOCK.get());
    private static final SurfaceRules.RuleSource RED_HARDENED_SAND = SurfaceRuleData.makeStateRule((Block)NatureBlocks.HARDENED_RED_SAND_BLOCK.get());
    private static final SurfaceRules.RuleSource MOIST_SAND = SurfaceRuleData.makeStateRule((Block)NatureBlocks.MOISTENED_SAND_BLOCK.get());
    private static final SurfaceRules.RuleSource GRASS_BLOCK = SurfaceRuleData.makeStateRule(Blocks.GRASS_BLOCK);
    private static final SurfaceRules.RuleSource JUNGLE_GRASS_BLOCK = SurfaceRuleData.makeStateRule((Block)NatureBlocks.JUNGLE_GRASS_BLOCK.get());
    private static final SurfaceRules.RuleSource CORRUPT_GRASS_BLOCK = SurfaceRuleData.makeStateRule((Block)NatureBlocks.CORRUPT_GRASS_BLOCK.get());
    private static final SurfaceRules.RuleSource EBONSTONE = SurfaceRuleData.makeStateRule((Block)NatureBlocks.EBONSTONE.get());
    private static final SurfaceRules.RuleSource EBONSAND = SurfaceRuleData.makeStateRule((Block)NatureBlocks.EBONSAND.get());
    private static final SurfaceRules.RuleSource CRIMSON_GRASS_BLOCK = SurfaceRuleData.makeStateRule((Block)NatureBlocks.CRIMSON_GRASS_BLOCK.get());
    private static final SurfaceRules.RuleSource CRIMSTONE = SurfaceRuleData.makeStateRule((Block)NatureBlocks.CRIMSTONE.get());
    private static final SurfaceRules.RuleSource CRIMSAND = SurfaceRuleData.makeStateRule((Block)NatureBlocks.CRIMSAND.get());
    private static final SurfaceRules.RuleSource MUSHROOM_GRASS_BLOCK = SurfaceRuleData.makeStateRule((Block)NatureBlocks.MUSHROOM_GRASS_BLOCK.get());
    private static final SurfaceRules.RuleSource MUD = SurfaceRuleData.makeStateRule(Blocks.MUD);
    private static final SurfaceRules.RuleSource ASH_BLOCK = SurfaceRuleData.makeStateRule((Block)NatureBlocks.ASH_BLOCK.get());
    private static final SurfaceRules.RuleSource ASH_GRASS_BLOCK = SurfaceRuleData.makeStateRule((Block)NatureBlocks.ASH_GRASS_BLOCK.get());
    private static final SurfaceRules.RuleSource DIATOMACEOUS = SurfaceRuleData.makeStateRule((Block)NatureBlocks.DIATOMACEOUS.get());
    private static final SurfaceRules.ConditionSource isAtOrAboveWaterLevel = SurfaceRules.waterBlockCheck((int)-1, (int)0);
    private static final SurfaceRules.ConditionSource isHole = SurfaceRules.not((SurfaceRules.ConditionSource)SurfaceRules.abovePreliminarySurface());
    private static final SurfaceRules.ConditionSource bedrockRoofSeed = SurfaceRules.verticalGradient((String)"minecraft:bedrock_roof", (VerticalAnchor)VerticalAnchor.belowTop((int)5), (VerticalAnchor)VerticalAnchor.belowTop((int)0));
    private static final SurfaceRules.ConditionSource bedrockFloorSeed = SurfaceRules.verticalGradient((String)"minecraft:bedrock_floor", (VerticalAnchor)VerticalAnchor.aboveBottom((int)0), (VerticalAnchor)VerticalAnchor.aboveBottom((int)5));
    private static final SurfaceRules.ConditionSource deepslateSeed = SurfaceRules.verticalGradient((String)"minecraft:deepslate", (VerticalAnchor)VerticalAnchor.absolute((int)0), (VerticalAnchor)VerticalAnchor.absolute((int)8));
    private static final SurfaceRules.ConditionSource grassSeed = SurfaceRules.verticalGradient((String)"minecraft:bedrock_floor", (VerticalAnchor)VerticalAnchor.absolute((int)48), (VerticalAnchor)VerticalAnchor.absolute((int)52));
    private static final SurfaceRules.ConditionSource sandSeed = SurfaceRules.verticalGradient((String)"minecraft:deepslate", (VerticalAnchor)VerticalAnchor.absolute((int)20), (VerticalAnchor)VerticalAnchor.absolute((int)25));
    private static final SurfaceRules.ConditionSource redSandSeed = SurfaceRules.verticalGradient((String)"minecraft:deepslate", (VerticalAnchor)VerticalAnchor.absolute((int)74), (VerticalAnchor)VerticalAnchor.absolute((int)76));
    private static final SurfaceRules.ConditionSource iceSeed = SurfaceRules.verticalGradient((String)"minecraft:deepslate", (VerticalAnchor)VerticalAnchor.absolute((int)20), (VerticalAnchor)VerticalAnchor.absolute((int)35));
    private static final SurfaceRules.ConditionSource mushroomSeed = SurfaceRules.verticalGradient((String)"minecraft:deepslate", (VerticalAnchor)VerticalAnchor.absolute((int)40), (VerticalAnchor)VerticalAnchor.absolute((int)42));
    private static final SurfaceRules.ConditionSource isOcean = SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{Biomes.OCEAN, Biomes.WARM_OCEAN, Biomes.LUKEWARM_OCEAN, Biomes.COLD_OCEAN, Biomes.FROZEN_OCEAN, Biomes.DEEP_OCEAN, Biomes.DEEP_FROZEN_OCEAN, Biomes.DEEP_LUKEWARM_OCEAN, Biomes.DEEP_COLD_OCEAN});
    private static final SurfaceRules.ConditionSource sandOcean = SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{Biomes.WARM_OCEAN, Biomes.DEEP_LUKEWARM_OCEAN});
    private static final SurfaceRules.ConditionSource snowy = SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{Biomes.ICE_SPIKES, Biomes.GROVE});
    private static final SurfaceRules.ConditionSource dirtSnowy = SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{Biomes.SNOWY_PLAINS, Biomes.SNOWY_TAIGA});
    private static final SurfaceRules.RuleSource corruptGrassSurface = SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)isAtOrAboveWaterLevel, (SurfaceRules.RuleSource)CORRUPT_GRASS_BLOCK), EBONSAND});
    private static final SurfaceRules.RuleSource crimsonGrassSurface = SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)isAtOrAboveWaterLevel, (SurfaceRules.RuleSource)CRIMSON_GRASS_BLOCK), CRIMSAND});
    private static final SurfaceRules.RuleSource mushroomSurface = SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)isAtOrAboveWaterLevel, (SurfaceRules.RuleSource)MUSHROOM_GRASS_BLOCK), MUD});
    private static final SurfaceRules.RuleSource ashGrassSurface = SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)isAtOrAboveWaterLevel, (SurfaceRules.RuleSource)ASH_GRASS_BLOCK), ASH_BLOCK});
    private static final SurfaceRules.RuleSource jungleGrassSurface = SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)isAtOrAboveWaterLevel, (SurfaceRules.RuleSource)JUNGLE_GRASS_BLOCK), MUD});
    private static final SurfaceRules.RuleSource grassSurface = SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)isAtOrAboveWaterLevel, (SurfaceRules.RuleSource)GRASS_BLOCK), DIRT});

    public static SurfaceRules.RuleSource makeConfluenceOverWorldRules() {
        return SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{ModBiomes.THE_CORRUPTION}), (SurfaceRules.RuleSource)SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.not((SurfaceRules.ConditionSource)grassSeed), (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.not((SurfaceRules.ConditionSource)isHole), (SurfaceRules.RuleSource)SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.ON_FLOOR, (SurfaceRules.RuleSource)corruptGrassSurface), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.stoneDepthCheck((int)4, (boolean)false, (int)1, (CaveSurface)CaveSurface.FLOOR), (SurfaceRules.RuleSource)DIRT)}))), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.not((SurfaceRules.ConditionSource)deepslateSeed), (SurfaceRules.RuleSource)EBONSTONE)})), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{ModBiomes.THE_CRIMSON}), (SurfaceRules.RuleSource)SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.not((SurfaceRules.ConditionSource)grassSeed), (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.not((SurfaceRules.ConditionSource)isHole), (SurfaceRules.RuleSource)SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.ON_FLOOR, (SurfaceRules.RuleSource)crimsonGrassSurface), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.stoneDepthCheck((int)4, (boolean)false, (int)1, (CaveSurface)CaveSurface.FLOOR), (SurfaceRules.RuleSource)DIRT)}))), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.not((SurfaceRules.ConditionSource)deepslateSeed), (SurfaceRules.RuleSource)CRIMSTONE)})), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{ModBiomes.GLOWING_MUSHROOM}), (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)mushroomSeed, (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.not((SurfaceRules.ConditionSource)bedrockFloorSeed), (SurfaceRules.RuleSource)SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.ON_FLOOR, (SurfaceRules.RuleSource)mushroomSurface), MUD}))))});
    }

    public static SurfaceRules.RuleSource makeConfluenceNetherRules() {
        return SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{ModBiomes.ASH_FOREST}), (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)bedrockRoofSeed, (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.not((SurfaceRules.ConditionSource)bedrockFloorSeed), (SurfaceRules.RuleSource)SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.ON_FLOOR, (SurfaceRules.RuleSource)ashGrassSurface), ASH_BLOCK})))), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{ModBiomes.ASH_WASTELAND}), (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)bedrockRoofSeed, (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.not((SurfaceRules.ConditionSource)bedrockFloorSeed), (SurfaceRules.RuleSource)ASH_BLOCK)))});
    }

    public static SurfaceRules.RuleSource makeMinecraftOverWorldRules() {
        return SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)isOcean, (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.not((SurfaceRules.ConditionSource)deepslateSeed), (SurfaceRules.RuleSource)SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)sandSeed, (SurfaceRules.RuleSource)HARDENED_SAND), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.stoneDepthCheck((int)6, (boolean)false, (int)3, (CaveSurface)CaveSurface.FLOOR), (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.not((SurfaceRules.ConditionSource)isHole), (SurfaceRules.RuleSource)SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)sandOcean, (SurfaceRules.RuleSource)MOIST_SAND), GRAVEL}))), DIATOMACEOUS}))), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{Biomes.JUNGLE, Biomes.SPARSE_JUNGLE, Biomes.BAMBOO_JUNGLE}), (SurfaceRules.RuleSource)SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.ON_FLOOR, (SurfaceRules.RuleSource)jungleGrassSurface), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.not((SurfaceRules.ConditionSource)bedrockFloorSeed), (SurfaceRules.RuleSource)MUD)})), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{Biomes.DESERT}), (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.not((SurfaceRules.ConditionSource)deepslateSeed), (SurfaceRules.RuleSource)SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.stoneDepthCheck((int)4, (boolean)false, (int)0, (CaveSurface)CaveSurface.FLOOR), (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.not((SurfaceRules.ConditionSource)isHole), (SurfaceRules.RuleSource)SAND)), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.stoneDepthCheck((int)10, (boolean)false, (int)5, (CaveSurface)CaveSurface.FLOOR), (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.not((SurfaceRules.ConditionSource)isHole), (SurfaceRules.RuleSource)SANDSTONE)), HARDENED_SAND}))), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.isBiome((ResourceKey[])new ResourceKey[]{Biomes.BADLANDS, Biomes.ERODED_BADLANDS}), (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.not((SurfaceRules.ConditionSource)deepslateSeed), (SurfaceRules.RuleSource)SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.stoneDepthCheck((int)2, (boolean)false, (int)0, (CaveSurface)CaveSurface.FLOOR), (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.not((SurfaceRules.ConditionSource)isHole), (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)redSandSeed, (SurfaceRules.RuleSource)RED_SAND))), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.stoneDepthCheck((int)10, (boolean)false, (int)5, (CaveSurface)CaveSurface.FLOOR), (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.not((SurfaceRules.ConditionSource)isHole), (SurfaceRules.RuleSource)SurfaceRules.bandlands())), RED_HARDENED_SAND}))), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)dirtSnowy, (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.not((SurfaceRules.ConditionSource)deepslateSeed), (SurfaceRules.RuleSource)SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)iceSeed, (SurfaceRules.RuleSource)PACKED_ICE), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.stoneDepthCheck((int)6, (boolean)false, (int)1, (CaveSurface)CaveSurface.FLOOR), (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.not((SurfaceRules.ConditionSource)isHole), (SurfaceRules.RuleSource)SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.ON_FLOOR, (SurfaceRules.RuleSource)grassSurface), DIRT}))), SNOW}))), SurfaceRules.ifTrue((SurfaceRules.ConditionSource)snowy, (SurfaceRules.RuleSource)SurfaceRules.ifTrue((SurfaceRules.ConditionSource)SurfaceRules.not((SurfaceRules.ConditionSource)deepslateSeed), (SurfaceRules.RuleSource)SurfaceRules.sequence((SurfaceRules.RuleSource[])new SurfaceRules.RuleSource[]{SurfaceRules.ifTrue((SurfaceRules.ConditionSource)iceSeed, (SurfaceRules.RuleSource)PACKED_ICE), SNOW})))});
    }

    private static SurfaceRules.RuleSource makeStateRule(Block block) {
        return SurfaceRules.state((BlockState)block.defaultBlockState());
    }
}

