/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.Level;
import org.confluence.lib.common.recipe.SimpleRecipeSerializer;
import org.confluence.mod.common.data.saved.GamePhase;
import org.confluence.mod.common.data.saved.KillBoard;
import org.confluence.mod.common.init.ModRecipes;
import org.confluence.mod.common.init.item.ToolItems;

public record ItemTransmutationRecipe(Ingredient source, List<ItemStack> target, int shrink, GamePhase gamePhase) implements Recipe<SingleRecipeInput>
{
    public boolean isValid() {
        return this.shrink > 0 && !this.target.isEmpty();
    }

    public boolean matches(SingleRecipeInput input, Level level) {
        return input.item().getCount() >= this.shrink && this.source.test(input.item()) && KillBoard.INSTANCE.getGamePhase().isAtLeast(this.gamePhase);
    }

    public ItemStack assemble(SingleRecipeInput input, HolderLookup.Provider registries) {
        return ItemStack.EMPTY;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return true;
    }

    public ItemStack getResultItem(HolderLookup.Provider registries) {
        return ItemStack.EMPTY;
    }

    public RecipeSerializer<?> getSerializer() {
        return ModRecipes.ITEM_TRANSMUTATION_SERIALIZER.get();
    }

    public RecipeType<?> getType() {
        return ModRecipes.ITEM_TRANSMUTATION_TYPE.get();
    }

    public NonNullList<Ingredient> getIngredients() {
        return NonNullList.withSize((int)1, (Object)this.source);
    }

    public boolean isSpecial() {
        return true;
    }

    public String getGroup() {
        return "item_transmutation";
    }

    public ItemStack getToastSymbol() {
        return ToolItems.BOTTOMLESS_SHIMMER_BUCKET.toStack();
    }

    public boolean isIncomplete() {
        return false;
    }

    public NonNullList<ItemStack> getRemainingItems(SingleRecipeInput input) {
        return NonNullList.withSize((int)1, (Object)ItemStack.EMPTY);
    }

    public static class Serializer
    extends SimpleRecipeSerializer<ItemTransmutationRecipe> {
        protected MapCodec<ItemTransmutationRecipe> getCodec() {
            return RecordCodecBuilder.mapCodec(instance -> instance.group((App)Ingredient.CODEC.fieldOf("source").forGetter(ItemTransmutationRecipe::source), (App)ItemStack.CODEC.listOf().lenientOptionalFieldOf("target", List.of()).forGetter(ItemTransmutationRecipe::target), (App)ExtraCodecs.POSITIVE_INT.lenientOptionalFieldOf("shrink", (Object)1).forGetter(ItemTransmutationRecipe::shrink), (App)GamePhase.CODEC.lenientOptionalFieldOf("game_phase", (Object)GamePhase.BEFORE_SKELETRON).forGetter(ItemTransmutationRecipe::gamePhase)).apply((Applicative)instance, ItemTransmutationRecipe::new));
        }

        protected StreamCodec<RegistryFriendlyByteBuf, ItemTransmutationRecipe> getStreamCodec() {
            return StreamCodec.composite((StreamCodec)Ingredient.CONTENTS_STREAM_CODEC, ItemTransmutationRecipe::source, (StreamCodec)ItemStack.LIST_STREAM_CODEC, ItemTransmutationRecipe::target, (StreamCodec)ByteBufCodecs.VAR_INT, ItemTransmutationRecipe::shrink, GamePhase.STREAM_CODEC, ItemTransmutationRecipe::gamePhase, ItemTransmutationRecipe::new);
        }
    }
}

