/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import org.confluence.lib.common.recipe.AbstractAmountRecipe;
import org.confluence.lib.common.recipe.AmountIngredient;
import org.confluence.lib.common.recipe.SimpleRecipeSerializer;
import org.confluence.mod.common.init.ModRecipes;
import org.confluence.mod.common.menu.AlchemyTableMenu;
import org.jetbrains.annotations.Nullable;

public class AlchemyTableRecipe
implements Recipe<Input> {
    private final ItemStack result;
    private final Ingredient base;
    private final NonNullList<Ingredient> ingredients;

    public AlchemyTableRecipe(ItemStack result, Ingredient base, NonNullList<Ingredient> ingredients) {
        if (ingredients.size() > 6) {
            throw new RuntimeException("Too many ingredients for '" + this.getGroup() + "' recipe. The maximum is: 6");
        }
        this.result = result;
        this.base = base;
        this.ingredients = ingredients;
    }

    public Ingredient getBase() {
        return this.base;
    }

    public NonNullList<Ingredient> getIngredients() {
        return this.ingredients;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean matches(Input input, Level level) {
        if (!this.base.test(input.getItem(0))) return false;
        if (!AbstractAmountRecipe.matches((int)input.materials.getContainerSize(), arg_0 -> ((SimpleContainer)input.materials).getItem(arg_0), this.ingredients)) return false;
        return true;
    }

    public ItemStack assemble(Input input, HolderLookup.Provider registries) {
        return this.getResultItem(null).copy();
    }

    public boolean canCraftInDimensions(int width, int height) {
        return true;
    }

    public ItemStack getResultItem(@Nullable HolderLookup.Provider registries) {
        return this.result;
    }

    public RecipeSerializer<?> getSerializer() {
        return ModRecipes.ALCHEMY_TABLE_SERIALIZER.get();
    }

    public RecipeType<?> getType() {
        return ModRecipes.ALCHEMY_TABLE_TYPE.get();
    }

    public static class Input
    extends SimpleContainer
    implements RecipeInput {
        private final AlchemyTableMenu menu;
        private final SimpleContainer materials = new SimpleContainer(6);

        public Input(AlchemyTableMenu menu) {
            super(1);
            this.menu = menu;
        }

        public SimpleContainer getMaterials() {
            return this.materials;
        }

        public void setItem(int index, ItemStack stack) {
            if (index == 0) {
                super.setItem(0, stack);
            } else {
                this.materials.setItem(index - 1, stack);
            }
        }

        public ItemStack getItem(int index) {
            if (index == 0) {
                return super.getItem(0);
            }
            return this.materials.getItem(index - 1);
        }

        public ItemStack removeItem(int index, int count) {
            if (index == 0) {
                return super.removeItem(0, count);
            }
            return this.materials.removeItem(index - 1, count);
        }

        public ItemStack removeItemNoUpdate(int index) {
            if (index == 0) {
                return super.removeItemNoUpdate(0);
            }
            return this.materials.removeItemNoUpdate(index - 1);
        }

        public void clearContent() {
            super.clearContent();
            this.materials.clearContent();
        }

        public boolean isEmpty() {
            return super.isEmpty() && this.materials.isEmpty();
        }

        public void setChanged() {
            super.setChanged();
            this.materials.setChanged();
            this.menu.slotsChanged((Container)this);
        }

        public int size() {
            return this.getContainerSize();
        }
    }

    public static class Serializer
    extends SimpleRecipeSerializer<AlchemyTableRecipe> {
        protected MapCodec<AlchemyTableRecipe> getCodec() {
            return RecordCodecBuilder.mapCodec(instance -> instance.group((App)ItemStack.STRICT_CODEC.fieldOf("result").forGetter(recipe -> recipe.result), (App)Ingredient.CODEC_NONEMPTY.fieldOf("base").forGetter(recipe -> recipe.base), (App)AbstractAmountRecipe.INGREDIENTS_CODEC.forGetter(recipe -> recipe.ingredients)).apply((Applicative)instance, AlchemyTableRecipe::new));
        }

        protected StreamCodec<RegistryFriendlyByteBuf, AlchemyTableRecipe> getStreamCodec() {
            return new StreamCodec<RegistryFriendlyByteBuf, AlchemyTableRecipe>(this){

                public AlchemyTableRecipe decode(RegistryFriendlyByteBuf buffer) {
                    int size = buffer.readVarInt();
                    NonNullList nonnulllist = NonNullList.withSize((int)size, (Object)AmountIngredient.EMPTY);
                    nonnulllist.replaceAll(ignore -> (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer));
                    ItemStack itemstack = (ItemStack)ItemStack.STREAM_CODEC.decode((Object)buffer);
                    Ingredient input = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer);
                    return new AlchemyTableRecipe(itemstack, input, (NonNullList<Ingredient>)nonnulllist);
                }

                public void encode(RegistryFriendlyByteBuf buffer, AlchemyTableRecipe recipe) {
                    buffer.writeVarInt(recipe.ingredients.size());
                    for (Ingredient ingredient : recipe.ingredients) {
                        Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)ingredient);
                    }
                    ItemStack.STREAM_CODEC.encode((Object)buffer, (Object)recipe.result);
                    Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)recipe.base);
                }
            };
        }
    }
}

