/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.menu;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundContainerSetSlotPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.level.block.Block;
import org.confluence.lib.common.menu.AmountResultSlot;
import org.confluence.lib.common.recipe.AbstractAmountRecipe;
import org.confluence.lib.common.recipe.EnvironmentLevelAccess;
import org.confluence.lib.common.recipe.EnvironmentRecipeInput;
import org.confluence.lib.common.recipe.MenuRecipeInput;
import org.confluence.mod.common.init.ModMenuTypes;
import org.confluence.mod.common.init.ModRecipes;
import org.confluence.mod.common.init.block.FunctionalBlocks;
import org.confluence.mod.common.recipe.SkyMillRecipe;

public class SkyMillMenu
extends AbstractContainerMenu {
    private static final int INV_SLOT_START = 4;
    private static final int INV_SLOT_END = 31;
    private static final int USE_ROW_SLOT_START = 31;
    private static final int USE_ROW_SLOT_END = 40;
    private final EnvironmentLevelAccess access;
    private final Player player;
    private Runnable slotUpdateListener = () -> {};
    public final EnvironmentRecipeInput input;
    private final AmountResultSlot<SkyMillRecipe> resultSlot;
    private final ResultContainer result = new ResultContainer();
    private final DataSlot selectedRecipeIndex = DataSlot.standalone();
    private List<RecipeHolder<SkyMillRecipe>> recipes = Lists.newArrayList();

    public SkyMillMenu(int containerId, Inventory inventory) {
        this(containerId, inventory, EnvironmentLevelAccess.empty());
    }

    public SkyMillMenu(int containerId, Inventory inventory, EnvironmentLevelAccess access) {
        super(ModMenuTypes.SKY_MILL.get(), containerId);
        this.access = access;
        this.player = inventory.player;
        this.access.initializeIfNeeded(this.player);
        this.input = new EnvironmentRecipeInput(this, 3, this.access){

            public void setChanged() {
                super.setChanged();
                SkyMillMenu.this.slotUpdateListener.run();
            }
        };
        this.resultSlot = new AmountResultSlot<SkyMillRecipe>((MenuRecipeInput)this.input, (Container)this.result, 0, 35, 14){

            public void onTake(Player pPlayer, ItemStack pStack) {
                super.onTake(pPlayer, pStack);
                SkyMillMenu.this.access.execute((level, pos) -> {
                    if (level instanceof ServerLevel) {
                        ServerLevel serverLevel = (ServerLevel)level;
                        serverLevel.sendParticles((ParticleOptions)ParticleTypes.CAMPFIRE_COSY_SMOKE, (double)pos.getX() + 0.5, (double)(pos.getY() + 1), (double)pos.getZ() + 0.5, 5, 0.0, 0.0, 0.0, 0.01);
                    }
                });
            }

            protected void updateMenu() {
                SkyMillMenu.this.setupResultSlot();
            }
        };
        this.addSlot((Slot)this.resultSlot);
        this.addSlot(new Slot((Container)this.input, 0, 35, 57));
        this.addSlot(new Slot((Container)this.input, 1, 16, 38));
        this.addSlot(new Slot((Container)this.input, 2, 54, 38));
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlot(new Slot((Container)inventory, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
        for (int k = 0; k < 9; ++k) {
            this.addSlot(new Slot((Container)inventory, k, 8 + k * 18, 142));
        }
        this.addDataSlot(this.selectedRecipeIndex);
    }

    public boolean stillValid(Player player) {
        return SkyMillMenu.stillValid((ContainerLevelAccess)this.access, (Player)player, (Block)((Block)FunctionalBlocks.SKY_MILL.get()));
    }

    public int getSelectedRecipeIndex() {
        return this.selectedRecipeIndex.get();
    }

    public List<RecipeHolder<SkyMillRecipe>> getRecipes() {
        return this.recipes;
    }

    public int getNumRecipes() {
        return this.recipes.size();
    }

    public boolean hasInputItem() {
        return !this.input.isEmpty() && !this.recipes.isEmpty();
    }

    public boolean clickMenuButton(Player player, int id) {
        if (this.isValidRecipeIndex(id)) {
            this.selectedRecipeIndex.set(id);
            this.setupResultSlot();
        }
        return true;
    }

    private boolean isValidRecipeIndex(int recipeIndex) {
        return recipeIndex >= 0 && recipeIndex < this.recipes.size();
    }

    public void slotsChanged(Container container) {
        this.recipes = this.player.level().getRecipeManager().getRecipesFor(ModRecipes.SKY_MILL_TYPE.get(), (RecipeInput)this.input, this.player.level());
        if (this.selectedRecipeIndex.get() >= this.recipes.size()) {
            this.selectedRecipeIndex.set(this.recipes.size() - 1);
        }
        this.access.execute((level, pos) -> {
            Player patt0$temp = this.player;
            if (patt0$temp instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)patt0$temp;
                ItemStack itemStack = ItemStack.EMPTY;
                if (!this.recipes.isEmpty()) {
                    if (this.selectedRecipeIndex.get() == -1) {
                        this.selectedRecipeIndex.set(0);
                    }
                    SkyMillRecipe recipe = (SkyMillRecipe)this.recipes.get(this.selectedRecipeIndex.get()).value();
                    itemStack = recipe.getResultItem(null).copy();
                    this.resultSlot.setCurrentRecipe((AbstractAmountRecipe)recipe);
                }
                this.result.setItem(0, itemStack);
                this.setRemoteSlot(0, itemStack);
                serverPlayer.connection.send((Packet)new ClientboundContainerSetSlotPacket(this.containerId, this.incrementStateId(), 0, itemStack));
            }
        });
    }

    private void setupResultSlot() {
        if (!this.recipes.isEmpty() && this.isValidRecipeIndex(this.selectedRecipeIndex.get())) {
            SkyMillRecipe recipe = (SkyMillRecipe)this.recipes.get(this.selectedRecipeIndex.get()).value();
            ItemStack itemStack = recipe.getResultItem(null).copy();
            if (itemStack.isItemEnabled(this.player.level().enabledFeatures())) {
                this.result.setItem(0, itemStack);
                this.resultSlot.setCurrentRecipe((AbstractAmountRecipe)recipe);
            } else {
                this.result.setItem(0, ItemStack.EMPTY);
            }
        } else {
            this.result.setItem(0, ItemStack.EMPTY);
        }
        this.broadcastChanges();
    }

    public void registerUpdateListener(Runnable listener) {
        this.slotUpdateListener = listener;
    }

    public boolean canTakeItemForPickAll(ItemStack stack, Slot slot) {
        return slot.container != this.result && super.canTakeItemForPickAll(stack, slot);
    }

    public ItemStack quickMoveStack(Player player, int index) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot.hasItem()) {
            ItemStack itemstack1 = slot.getItem();
            Item item = itemstack1.getItem();
            itemstack = itemstack1.copy();
            if (index == 0) {
                item.onCraftedBy(itemstack1, player.level(), player);
                if (!this.moveItemStackTo(itemstack1, 4, 40, true)) {
                    return ItemStack.EMPTY;
                }
                slot.onQuickCraft(itemstack1, itemstack);
            } else if (index < 4 ? !this.moveItemStackTo(itemstack1, 4, 40, false) : !this.moveItemStackTo(itemstack1, 1, 4, false) && (index < 31 ? !this.moveItemStackTo(itemstack1, 31, 40, false) : index < 40 && !this.moveItemStackTo(itemstack1, 4, 31, false))) {
                return ItemStack.EMPTY;
            }
            if (itemstack1.isEmpty()) {
                slot.setByPlayer(ItemStack.EMPTY);
            }
            slot.setChanged();
            if (itemstack1.getCount() == itemstack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(player, itemstack1);
            this.broadcastChanges();
        }
        return itemstack;
    }

    public void removed(Player player) {
        super.removed(player);
        this.result.removeItemNoUpdate(0);
        this.access.execute((level, blockPos) -> this.clearContainer(player, (Container)this.input));
    }
}

