/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.menu;

import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import org.confluence.lib.common.menu.ContainerResultSlot;
import org.confluence.mod.common.init.ModMenuTypes;

public class CookingPotMenu
extends AbstractContainerMenu {
    public static final int INPUT_SLOT_1 = 0;
    public static final int INPUT_SLOT_2 = 1;
    public static final int INPUT_SLOT_3 = 2;
    public static final int INPUT_SLOT_4 = 3;
    public static final int CONTAINER_SLOT = 4;
    public static final int RESULT_SLOT = 5;
    public static final int SLOT_COUNT = 6;
    public static final int DATA_COUNT = 3;
    private static final int INV_SLOT_START = 6;
    private static final int INV_SLOT_END = 33;
    private static final int USE_ROW_SLOT_START = 33;
    private static final int USE_ROW_SLOT_END = 42;
    private final Container potContainer;
    private final ContainerData potData;
    private int cachedId = Item.getId((Item)Items.AIR);
    private ItemStack cachedHeatSource = new ItemStack((ItemLike)Items.AIR);

    public CookingPotMenu(int containerId, Inventory inventory) {
        this(containerId, inventory, (Container)new SimpleContainer(6), (ContainerData)new SimpleContainerData(3));
    }

    public CookingPotMenu(int containerId, Inventory inventory, Container potContainer, ContainerData potData) {
        super(ModMenuTypes.COOKING_POT.get(), containerId);
        CookingPotMenu.checkContainerSize((Container)potContainer, (int)6);
        CookingPotMenu.checkContainerDataCount((ContainerData)potData, (int)3);
        this.potContainer = potContainer;
        this.potData = potData;
        this.addSlot(new Slot(potContainer, 0, 26, 26));
        this.addSlot(new Slot(potContainer, 1, 44, 26));
        this.addSlot(new Slot(potContainer, 2, 26, 44));
        this.addSlot(new Slot(potContainer, 3, 44, 44));
        this.addSlot(new Slot(potContainer, 4, 92, 20));
        this.addSlot((Slot)new ContainerResultSlot(potContainer, 5, 134, 35));
        for (int k = 0; k < 3; ++k) {
            for (int l = 0; l < 9; ++l) {
                this.addSlot(new Slot((Container)inventory, l + k * 9 + 9, 8 + l * 18, 84 + k * 18));
            }
        }
        for (int m = 0; m < 9; ++m) {
            this.addSlot(new Slot((Container)inventory, m, 8 + m * 18, 142));
        }
        this.addDataSlots(potData);
    }

    public boolean stillValid(Player player) {
        return this.potContainer.stillValid(player);
    }

    public ItemStack quickMoveStack(Player player, int index) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot.hasItem()) {
            ItemStack itemstack1 = slot.getItem();
            itemstack = itemstack1.copy();
            if (index == 5) {
                if (!this.moveItemStackTo(itemstack1, 6, 42, true)) {
                    return ItemStack.EMPTY;
                }
                slot.onQuickCraft(itemstack1, itemstack);
            } else if (index > 4) {
                if (!this.moveItemStackTo(itemstack1, 0, 4, false)) {
                    if (index < 33 ? !this.moveItemStackTo(itemstack1, 33, 42, false) : index < 42 && !this.moveItemStackTo(itemstack1, 6, 33, false)) {
                        return ItemStack.EMPTY;
                    }
                    return ItemStack.EMPTY;
                }
                if (!this.moveItemStackTo(itemstack1, 4, 5, false)) {
                    return ItemStack.EMPTY;
                }
            } else if (!this.moveItemStackTo(itemstack1, 6, 42, false)) {
                return ItemStack.EMPTY;
            }
            if (itemstack1.isEmpty()) {
                slot.setByPlayer(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (itemstack1.getCount() == itemstack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(player, itemstack1);
        }
        return itemstack;
    }

    public float getBurnProgress() {
        int i = this.potData.get(0);
        int j = this.potData.get(1);
        return j != 0 && i != 0 ? Mth.clamp((float)((float)i / (float)j), (float)0.0f, (float)1.0f) : 0.0f;
    }

    public ItemStack getHeatSourceItem() {
        int i = this.potData.get(2);
        if (this.cachedId != i) {
            this.cachedHeatSource = Item.byId((int)i).getDefaultInstance();
            this.cachedId = i;
        }
        return this.cachedHeatSource;
    }
}

