/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.loot;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import org.confluence.mod.common.data.saved.GamePhase;
import org.confluence.mod.common.data.saved.KillBoard;
import org.confluence.mod.common.init.ModLootTables;

public record GamePhaseLootItemCondition(GamePhase from, boolean fromInclusive, GamePhase to, boolean toInclusive) implements LootItemCondition
{
    public static final MapCodec<GamePhaseLootItemCondition> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)GamePhase.CODEC.fieldOf("from").forGetter(GamePhaseLootItemCondition::from), (App)Codec.BOOL.lenientOptionalFieldOf("from_inclusive", (Object)true).forGetter(GamePhaseLootItemCondition::fromInclusive), (App)GamePhase.CODEC.fieldOf("to").forGetter(GamePhaseLootItemCondition::to), (App)Codec.BOOL.lenientOptionalFieldOf("to_inclusive", (Object)true).forGetter(GamePhaseLootItemCondition::toInclusive)).apply((Applicative)instance, GamePhaseLootItemCondition::new));

    public LootItemConditionType getType() {
        return ModLootTables.ItemConditions.GAME_PHASE.get();
    }

    public boolean test(LootContext context) {
        GamePhase gamePhase = KillBoard.INSTANCE.getGamePhase();
        if (this.fromInclusive ? gamePhase.isAtLeast(this.from) : gamePhase.isAboveThan(this.from)) {
            return !(!this.toInclusive ? gamePhase.isAtLeast(this.to) : gamePhase.isAboveThan(this.to));
        }
        return false;
    }

    @Override
    public boolean equals(Object o) {
        boolean bl;
        block7: {
            block5: {
                block6: {
                    boolean bl2;
                    GamePhase gamePhase;
                    boolean bl3;
                    GamePhase from1;
                    if (o == this) break block6;
                    if (!(o instanceof GamePhaseLootItemCondition)) break block5;
                    GamePhaseLootItemCondition gamePhaseLootItemCondition = (GamePhaseLootItemCondition)o;
                    try {
                        GamePhase gamePhase2;
                        from1 = gamePhase2 = gamePhaseLootItemCondition.from();
                    }
                    catch (Throwable throwable) {
                        throw new MatchException(throwable.toString(), throwable);
                    }
                    boolean fromInclusive1 = bl3 = gamePhaseLootItemCondition.fromInclusive();
                    GamePhase to1 = gamePhase = gamePhaseLootItemCondition.to();
                    boolean toInclusive1 = bl2 = gamePhaseLootItemCondition.toInclusive();
                    if (this.from != from1 || this.fromInclusive != fromInclusive1 || this.to != to1 || this.toInclusive != toInclusive1) break block5;
                }
                bl = true;
                break block7;
            }
            bl = false;
        }
        return bl;
    }

    @Override
    public int hashCode() {
        int result = Objects.hashCode((Object)this.from);
        result = 31 * result + Boolean.hashCode(this.fromInclusive);
        result = 31 * result + Objects.hashCode((Object)this.to);
        result = 31 * result + Boolean.hashCode(this.toInclusive);
        return result;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    implements LootItemCondition.Builder {
        private GamePhase from = GamePhase.BEFORE_SKELETRON;
        private boolean fromInclusive = true;
        private GamePhase to = GamePhase.MOON_LORD;
        private boolean toInclusive = true;

        public Builder from(GamePhase from) {
            this.from = from;
            return this;
        }

        public Builder from(GamePhase from, boolean inclusive) {
            this.from = from;
            this.fromInclusive = inclusive;
            return this;
        }

        public Builder to(GamePhase to) {
            this.to = to;
            return this;
        }

        public Builder to(GamePhase to, boolean inclusive) {
            this.to = to;
            this.toInclusive = inclusive;
            return this;
        }

        public GamePhaseLootItemCondition build() {
            return new GamePhaseLootItemCondition(this.from, this.fromInclusive, this.to, this.toInclusive);
        }
    }
}

