/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.item.sword;

import java.util.function.Consumer;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.level.Level;
import org.confluence.lib.ConfluenceMagicLib;
import org.confluence.lib.common.component.ModRarity;
import org.confluence.mod.client.renderer.item.PhasebladeRenderer;
import org.confluence.mod.common.init.ModSoundEvents;
import org.confluence.mod.common.item.sword.BaseSwordItem;
import org.confluence.mod.common.item.sword.legacy.SwordPrefabs;
import org.confluence.terraentity.data.component.SingleBooleanComponent;
import org.confluence.terraentity.init.TEDataComponentTypes;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.animatable.SingletonGeoAnimatable;
import software.bernie.geckolib.animatable.client.GeoRenderProvider;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class Phaseblade
extends BaseSwordItem
implements GeoItem {
    public int frame = 0;
    private final String color;
    private final ItemAttributeModifiers turnOnModifiers;
    private final ItemAttributeModifiers turnOffModifiers;
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public Phaseblade(Tier tier, ModRarity rarity, int rawDamage, float rawSpeed, String color) {
        super(tier, rarity, 0, rawSpeed, SwordPrefabs.withSpecialSweep(0.8f, new BaseSwordItem.ModifierBuilder(){

            @Override
            public Item.Properties buildProperties(Tier tier, ModRarity rarity, int rawDamage, float rawSpeed) {
                if (this.modifier != null) {
                    this.modifier.forEach(m -> m.accept(this.properties));
                }
                this.properties = this.properties.durability(tier.getUses()).component(ConfluenceMagicLib.MOD_RARITY, (Object)rarity);
                return this.properties;
            }
        }.modifyProperties(p -> p.component((DataComponentType)TEDataComponentTypes.BOOMERANG_READY.get(), (Object)SingleBooleanComponent.TRUE))));
        this.color = color;
        this.turnOnModifiers = Phaseblade.createAttributes((Tier)tier, (float)((float)rawDamage - tier.getAttackDamageBonus() - 1.0f), (float)(rawSpeed - 4.0f));
        this.turnOffModifiers = Phaseblade.createAttributes((Tier)tier, (float)(1.0f - tier.getAttackDamageBonus()), (float)-2.0f);
        SingletonGeoAnimatable.registerSyncedAnimatable((GeoAnimatable)this);
    }

    public static boolean isTurnOn(ItemStack itemStack) {
        return ((SingleBooleanComponent)itemStack.getComponents().getOrDefault((DataComponentType)TEDataComponentTypes.BOOMERANG_READY.get(), (Object)SingleBooleanComponent.TRUE)).value();
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        return ItemUtils.startUsingInstantly((Level)level, (Player)player, (InteractionHand)hand);
    }

    public UseAnim getUseAnimation(ItemStack itemStack) {
        return UseAnim.BLOCK;
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return 20;
    }

    public ItemStack finishUsingItem(ItemStack itemStack, Level level, LivingEntity living) {
        boolean turnOn;
        if (level.isClientSide) {
            return itemStack;
        }
        SingleBooleanComponent component = (SingleBooleanComponent)itemStack.set((DataComponentType)TEDataComponentTypes.BOOMERANG_READY.get(), (Object)new SingleBooleanComponent(!Phaseblade.isTurnOn(itemStack)));
        boolean bl = turnOn = component == null || !component.value();
        if (turnOn) {
            this.triggerAnim((Entity)living, GeoItem.getOrAssignId((ItemStack)itemStack, (ServerLevel)((ServerLevel)level)), "light", "on");
            level.playSound(null, living.blockPosition().above(), (SoundEvent)ModSoundEvents.LIGHTSABER_OPEN.get(), SoundSource.PLAYERS, 2.0f, 1.0f);
        } else {
            this.triggerAnim((Entity)living, GeoItem.getOrAssignId((ItemStack)itemStack, (ServerLevel)((ServerLevel)level)), "light", "off");
            level.playSound(null, living.blockPosition().above(), (SoundEvent)ModSoundEvents.LIGHTSABER_OPEN.get(), SoundSource.PLAYERS);
        }
        if (living instanceof Player) {
            Player player = (Player)living;
            player.getCooldowns().addCooldown((Item)this, 10);
        }
        return itemStack;
    }

    public ItemAttributeModifiers getDefaultAttributeModifiers(ItemStack stack) {
        return ((SingleBooleanComponent)stack.getOrDefault(TEDataComponentTypes.BOOMERANG_READY, (Object)SingleBooleanComponent.TRUE)).value() ? this.turnOnModifiers : this.turnOffModifiers;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, "light", state -> PlayState.STOP).triggerableAnim("off", RawAnimation.begin().thenPlay("turn_off")).triggerableAnim("on", RawAnimation.begin().thenPlay("turn_on")));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void createGeoRenderer(Consumer<GeoRenderProvider> consumer) {
        consumer.accept(new GeoRenderProvider(){
            private PhasebladeRenderer renderer;

            public BlockEntityWithoutLevelRenderer getGeoItemRenderer() {
                if (this.renderer == null) {
                    this.renderer = new PhasebladeRenderer(Phaseblade.this.color);
                }
                return this.renderer;
            }
        });
    }
}

