/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.item.sword;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.ItemAbility;
import org.confluence.lib.ConfluenceMagicLib;
import org.confluence.lib.common.component.ModRarity;
import org.confluence.lib.util.consumer.Consumer4;
import org.confluence.mod.Confluence;
import org.confluence.mod.common.component.SwordProjectileComponent;
import org.confluence.mod.common.entity.projectile.sword.SwordProjectile;
import org.confluence.mod.common.init.ModDataComponentTypes;
import org.confluence.mod.common.init.item.ModItems;
import org.confluence.mod.common.item.tooltipcomponent.AltImageComponent;
import org.confluence.mod.util.ModUtils;
import org.confluence.terraentity.data.component.EffectStrategyComponent;
import org.confluence.terraentity.init.TEDataComponentTypes;
import org.confluence.terraentity.registries.hit_effect.IEffectStrategy;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class BaseSwordItem
extends SwordItem {
    @Nullable
    public ModifierBuilder modifier;
    @Nullable
    private TooltipComponent component;

    public BaseSwordItem(Tier tier, Item.Properties properties) {
        super(tier, properties);
    }

    public BaseSwordItem(Tier tier, int rawDamage, float rawSpeed) {
        this(tier, ModRarity.WHITE, rawDamage, rawSpeed);
    }

    public BaseSwordItem(Tier tier, ModRarity rarity, int rawDamage, float rawSpeed) {
        super(tier, new Item.Properties().durability(tier.getUses()).component(ConfluenceMagicLib.MOD_RARITY, (Object)rarity).component(DataComponents.ATTRIBUTE_MODIFIERS, (Object)BaseSwordItem.createAttributes((Tier)tier, (float)((float)rawDamage - tier.getAttackDamageBonus() - 1.0f), (float)(rawSpeed - 4.0f))));
        this.modifier = new ModifierBuilder();
    }

    public BaseSwordItem(Tier tier, ModRarity rarity, int rawDamage, float rawSpeed, ModifierBuilder modifier) {
        super(tier, modifier.buildProperties(tier, rarity, rawDamage, rawSpeed));
        this.modifier = modifier;
    }

    public Optional<TooltipComponent> getTooltipImage(ItemStack stack) {
        if (this.component == null && this.modifier != null && this.modifier.hasImage) {
            this.component = AltImageComponent.of(stack.getItem());
        }
        return Optional.ofNullable(this.component);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void applyHitEffects(ItemStack weapon, @Nullable Entity attacker, LivingEntity hurter, DamageSource damageSource) {
        if (this.modifier == null) return;
        if (!damageSource.is(DamageTypeTags.PANIC_CAUSES)) return;
        EffectStrategyComponent data = (EffectStrategyComponent)weapon.get(TEDataComponentTypes.EFFECT_STRATEGY);
        if (data == null) return;
        if (attacker instanceof Player) {
            Player player = (Player)attacker;
            if (damageSource.is(DamageTypeTags.CAN_BREAK_ARMOR_STAND) && damageSource.is(DamageTypeTags.IS_PLAYER_ATTACK)) {
                if (!(player.getAttackStrengthScale(0.5f) > 0.95f)) return;
                data.applyAll((LivingEntity)player, hurter);
                return;
            }
        }
        if (!(attacker instanceof LivingEntity)) return;
        LivingEntity livingEntity = (LivingEntity)attacker;
        data.applyAll(livingEntity, hurter);
    }

    public void genProjectile(LivingEntity living, ItemStack weapon, SwordProjectileComponent data) {
        living.level().playSound(null, living.getX(), living.getY(), living.getZ(), data.getSoundEvent(), SoundSource.AMBIENT, 1.0f, 1.0f);
        try {
            data.generation().genProjectile(living, weapon, data.getVelocity(living), () -> {
                Entity patt0$temp = ((EntityType)BuiltInRegistries.ENTITY_TYPE.get(data.projType())).create(living.level());
                if (patt0$temp instanceof SwordProjectile) {
                    SwordProjectile projectile = (SwordProjectile)patt0$temp;
                    projectile.setProjComponent(data);
                    projectile.addAttackDamage((float)((double)data.damageFactor() * living.getAttributeValue(Attributes.ATTACK_DAMAGE)));
                    return projectile;
                }
                living.sendSystemMessage((Component)Component.literal((String)"Error DataComponent sword_projectile: projType must be a SwordProjectile"));
                return null;
            });
        }
        catch (Exception e) {
            Confluence.LOGGER.error("Error DataComponent sword_projectile: projType must be a SwordProjectile");
        }
    }

    public boolean supportsEnchantment(ItemStack stack, Holder<Enchantment> enchantment) {
        return ModUtils.supportsEnchantment(stack, enchantment);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        SwordProjectileComponent data;
        EffectStrategyComponent hitEffects = (EffectStrategyComponent)stack.get(TEDataComponentTypes.EFFECT_STRATEGY);
        if (hitEffects != null) {
            IEffectStrategy.appendDescription(tooltipComponents, (List)hitEffects.effects(), (Component)Component.translatable((String)"tooltip.item.confluence.on_hit_effects").append(": ").withColor(9869329));
        }
        if ((data = (SwordProjectileComponent)stack.get(ModDataComponentTypes.SWORD_PROJECTILE)) != null) {
            tooltipComponents.add((Component)Component.translatable((String)"tooltip.item.confluence.has_proj").withColor(5754363));
            tooltipComponents.add((Component)Component.translatable((String)"tooltip.item.confluence.has_proj.damage").append(": x" + data.damageFactor()).withColor(5754363));
            tooltipComponents.add((Component)Component.translatable((String)"tooltip.item.confluence.has_proj.speed").append(": " + data.baseSpeed()).withColor(5754363));
            tooltipComponents.add((Component)Component.translatable((String)"tooltip.item.confluence.has_proj.cooldown").append(": " + data.cooldown()).withColor(5754363));
            if (data.trackType().isPresent()) {
                data.trackType().ifPresent(type -> tooltipComponents.add((Component)Component.translatable((String)"tooltip.item.confluence.has_proj.track_type").append(": ").append((Component)Component.translatable((String)type.getName())).withColor(5754363)));
            }
        }
        if (this.modifier != null) {
            for (int i = 0; i < this.modifier.tooltipsModifier.size(); ++i) {
                if (i == 0) {
                    tooltipComponents.add((Component)Component.empty());
                }
                Consumer<MutableComponent> it = this.modifier.tooltipsModifier.get(i);
                MutableComponent component = Component.translatable((String)("tooltip.item.confluence." + BuiltInRegistries.ITEM.getKey((Object)this).getPath() + "." + i)).withStyle(style -> style.withColor(0x666666).withItalic(Boolean.valueOf(true)));
                it.accept(component);
                tooltipComponents.add((Component)component);
            }
        }
    }

    public AABB getSweepHitBox(ItemStack stack, Player player, Entity target) {
        if (this.modifier != null && this.modifier.specialSweep) {
            return BaseSwordItem.getSpecialSweepArea(player);
        }
        return super.getSweepHitBox(stack, player, target);
    }

    public static AABB getSpecialSweepArea(Player player) {
        Vec3 start = player.getEyePosition();
        Vec3 up = player.getUpVector(1.0f);
        Vec3 forward = player.getViewVector(1.0f).scale(player.getAttributeValue(Attributes.ENTITY_INTERACTION_RANGE));
        Vec3 end = start.add(forward);
        Vec3 left = forward.cross(up);
        return new AABB(start.add(left), end.add(left.reverse()));
    }

    public boolean canPerformAction(ItemStack stack, ItemAbility itemAbility) {
        boolean b = super.canPerformAction(stack, itemAbility);
        if (this.modifier != null) {
            return b && this.modifier.canPerformSweep;
        }
        return b;
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entity, int slotId, boolean isSelected) {
        if (this.modifier != null && this.modifier.inventoryTick != null) {
            this.modifier.inventoryTick.accept((Object)stack, (Object)level, (Object)entity, (Object)isSelected);
        }
    }

    public static class ModifierBuilder {
        public boolean canPerformSweep = true;
        public boolean specialSweep = false;
        protected Item.Properties properties = new Item.Properties();
        private Consumer4<ItemStack, Level, Entity, Boolean> inventoryTick;
        private final ItemAttributeModifiers.Builder attributeModifiersBuilder = ItemAttributeModifiers.builder();
        private int modifyCount = 0;
        protected List<Consumer<Item.Properties>> modifier = new ArrayList<Consumer<Item.Properties>>();
        List<Consumer<MutableComponent>> tooltipsModifier = new ArrayList<Consumer<MutableComponent>>();
        boolean hasImage;

        public ModifierBuilder hasImage() {
            this.hasImage = true;
            return this;
        }

        public ModifierBuilder setOnHitEffect(EffectStrategyComponent onHit) {
            this.modifier.add(p -> p.component(TEDataComponentTypes.EFFECT_STRATEGY, (Object)onHit));
            return this;
        }

        public ModifierBuilder addAttributeModifier(Holder<Attribute> attribute, float amount, AttributeModifier.Operation operation) {
            this.attributeModifiersBuilder.add(attribute, new AttributeModifier(Confluence.asResource("sword.modifier." + this.modifyCount++), (double)amount, operation), EquipmentSlotGroup.MAINHAND);
            return this;
        }

        public ModifierBuilder setProj(Supplier<SwordProjectileComponent> proj) {
            this.modifier.add(p -> p.component(ModDataComponentTypes.SWORD_PROJECTILE, (Object)((SwordProjectileComponent)proj.get())));
            return this;
        }

        public ModifierBuilder setCanNotPerformSweep() {
            this.canPerformSweep = false;
            return this;
        }

        public ModifierBuilder setSpecialSweep() {
            this.specialSweep = true;
            return this;
        }

        public ModifierBuilder setInventoryTick(Consumer4<ItemStack, Level, Entity, Boolean> inventoryTick) {
            this.inventoryTick = inventoryTick;
            return this;
        }

        public ModifierBuilder modifyProperties(Consumer<Item.Properties> modifier) {
            this.modifier.add(modifier);
            return this;
        }

        public ModifierBuilder unbreakable() {
            this.modifier.add(properties -> properties.component(DataComponents.UNBREAKABLE, (Object)ModItems.UNBREAKABLE));
            return this;
        }

        public ModifierBuilder addTooltip(int count) {
            for (int i = 0; i < count; ++i) {
                this.addTooltip();
            }
            return this;
        }

        public ModifierBuilder addTooltip() {
            this.addTooltip(p -> {});
            return this;
        }

        public ModifierBuilder addTooltip(int count, Consumer<MutableComponent> tooltips) {
            for (int i = 0; i < count; ++i) {
                this.addTooltip(tooltips);
            }
            return this;
        }

        public ModifierBuilder addTooltip(Consumer<MutableComponent> tooltips) {
            this.tooltipsModifier.add(tooltips);
            return this;
        }

        public Item.Properties buildProperties(Tier tier, ModRarity rarity, int rawDamage, float rawSpeed) {
            if (this.modifier != null) {
                this.modifier.forEach(m -> m.accept(this.properties));
            }
            this.properties.durability(tier.getUses()).component(ConfluenceMagicLib.MOD_RARITY, (Object)rarity).component(DataComponents.ATTRIBUTE_MODIFIERS, (Object)this.attributeModifiersBuilder.add(Attributes.ATTACK_DAMAGE, new AttributeModifier(Item.BASE_ATTACK_DAMAGE_ID, (double)(rawDamage - 1), AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).add(Attributes.ATTACK_SPEED, new AttributeModifier(Item.BASE_ATTACK_SPEED_ID, (double)(rawSpeed - 4.0f), AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).build());
            return this.properties;
        }
    }
}

