/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.item.sponsor;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.mojang.serialization.DynamicOps;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.confluence.lib.common.component.ModRarity;
import org.confluence.lib.util.LibUtils;
import org.confluence.mod.Confluence;
import org.confluence.mod.common.block.functional.boulder.AbstractBoulderBlock;
import org.confluence.mod.common.entity.projectile.boulder.BoulderEntity;
import org.confluence.mod.common.init.ModSecretSeeds;
import org.confluence.mod.common.init.block.FunctionalBlocks;
import org.confluence.terra_curio.common.init.TCAttributes;
import org.confluence.terra_curio.common.item.curio.BaseCurioItem;
import org.confluence.terraentity.init.TEAttributes;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurio;

public class BoredomsPactFallingResolve
extends BaseCurioItem {
    public static final ResourceLocation ID = Confluence.asResource("boredoms_pact_falling_resolve");

    public BoredomsPactFallingResolve() {
        super(BoredomsPactFallingResolve.builder((String)ID.getPath()).rarity(ModRarity.MASTER).tooltips(8));
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        LivingEntity living = slotContext.entity();
        Level level = living.level();
        if (level.isClientSide) {
            return;
        }
        LibUtils.updateItemStackNbt((ItemStack)stack, tag -> {
            Vec3 currentPos = BoredomsPactFallingResolve.readPos(tag);
            if (currentPos == null) {
                BoredomsPactFallingResolve.savePos(tag, living);
            } else {
                byte count = tag.getByte("count");
                Vec3 pos = living.position().subtract(currentPos);
                if (Math.abs(pos.x) < (double)1.0E-5f && Math.abs(pos.y) < (double)1.0E-5f && Math.abs(pos.z) < (double)1.0E-5f) {
                    if (level.getGameTime() % 20L == 0L) {
                        if (count > 0) {
                            count = (byte)(count - 1);
                            tag.putByte("count", count);
                        } else if (!tag.getBoolean("summoned")) {
                            int i;
                            BlockPos.MutableBlockPos mutable = living.blockPosition().mutable();
                            for (i = 0; i < 16 && level.getBlockState((BlockPos)mutable).getCollisionShape((BlockGetter)level, (BlockPos)mutable).isEmpty(); ++i) {
                                mutable.move(0, 1, 0);
                            }
                            BlockState blockState = level.getBlockState(living.blockPosition().below());
                            if (blockState.isAir()) {
                                blockState = ((AbstractBoulderBlock)FunctionalBlocks.NORMAL_BOULDER.get()).defaultBlockState();
                            }
                            level.addFreshEntity((Entity)new BoulderEntity(level, currentPos.add(0.0, (double)i, 0.0), blockState));
                            tag.putBoolean("summoned", true);
                        }
                    }
                } else {
                    double h = tag.getDouble("h");
                    double v = tag.getDouble("v");
                    if (v >= 5.0 || h >= 6.0) {
                        if (count < 8) {
                            count = (byte)(count + 1);
                            tag.putByte("count", count);
                        }
                        h = 0.0;
                        v = 0.0;
                    } else {
                        h += pos.horizontalDistance();
                        v += Math.abs(pos.y);
                    }
                    tag.putDouble("h", h);
                    tag.putDouble("v", v);
                    BoredomsPactFallingResolve.savePos(tag, living);
                    tag.putBoolean("summoned", false);
                }
            }
        });
    }

    public Multimap<Holder<Attribute>, AttributeModifier> getAttributeModifiers(SlotContext slotContext, ResourceLocation id, ItemStack stack) {
        AttributeModifier modifier = new AttributeModifier(ID, 0.2 * (double)LibUtils.getItemStackNbtNoCopy((ItemStack)stack).getByte("count"), AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
        return ImmutableMultimap.of((Object)Attributes.ATTACK_DAMAGE, (Object)modifier, (Object)TCAttributes.getMagicDamage(), (Object)modifier, (Object)TCAttributes.getRangedDamage(), (Object)modifier, (Object)TEAttributes.SUMMON_DAMAGE, (Object)modifier, (Object)TCAttributes.getCriticalChance(), (Object)modifier);
    }

    public ICurio.DropRule getDropRule(SlotContext slotContext, DamageSource source, boolean recentlyHit, ItemStack stack) {
        return ModSecretSeeds.BOULDER_WORLD.match() ? ICurio.DropRule.ALWAYS_KEEP : ICurio.DropRule.DEFAULT;
    }

    private static void savePos(CompoundTag tag, LivingEntity living) {
        tag.put("currentPos", (Tag)Vec3.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)living.position()).getOrThrow());
    }

    @Nullable
    private static Vec3 readPos(CompoundTag tag) {
        return Vec3.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)tag.get("currentPos")).result().orElse(null);
    }
}

