/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.item.paint;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.UseOnContext;
import org.confluence.lib.common.component.ModRarity;
import org.confluence.lib.common.item.TooltipItem;
import org.confluence.mod.common.item.paint.PaintItem;
import org.confluence.mod.network.s2c.BrushingColorPacketS2C;

public class PaintRollerItem
extends TooltipItem {
    public PaintRollerItem(Item.Properties properties, ModRarity rarity, List<Component> tooltips) {
        super(properties.stacksTo(1), rarity, tooltips);
    }

    public InteractionResult useOn(UseOnContext pContext) {
        Player player = pContext.getPlayer();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            ServerLevel serverLevel = serverPlayer.serverLevel();
            BlockPos clickedPos = pContext.getClickedPos();
            Direction clickedFace = pContext.getClickedFace();
            int color = PaintItem.useAndGetRGB(pContext.getPlayer());
            if (color != -1) {
                BrushingColorPacketS2C.sendToPlayersTrackingChunk(serverLevel, clickedPos, clickedFace, color, true);
            }
        }
        return InteractionResult.SUCCESS;
    }
}

