/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.item.mana;

import java.util.List;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.entity.PartEntity;
import org.confluence.lib.common.component.ModRarity;
import org.confluence.lib.common.item.CustomRarityItem;
import org.confluence.mod.Confluence;
import org.confluence.mod.common.entity.projectile.DamageSettableProjectile;
import org.confluence.mod.common.init.ModSoundEvents;
import org.confluence.mod.util.PlayerUtils;
import org.confluence.mod.util.PrefixUtils;
import org.confluence.terra_curio.common.init.TCAttributes;

public class ManaStaffItem<E extends DamageSettableProjectile>
extends CustomRarityItem {
    public static final ResourceLocation ID = Confluence.asResource("mana_staff");
    protected final ProjectileFactory<E> factory;
    protected final float damage;
    protected final int manaCost;
    protected final float velocity;
    protected final int cooldown;

    public ManaStaffItem(Item.Properties properties, ModRarity rarity, ProjectileFactory<E> factory, float damage, int manaCost, float rawVelocity, int cooldown) {
        super(properties, rarity);
        this.damage = damage;
        this.factory = factory;
        this.manaCost = manaCost;
        this.velocity = rawVelocity / 8.0f;
        this.cooldown = cooldown;
    }

    public ManaStaffItem(ModRarity rarity, ProjectileFactory<E> factory, float damage, int manaCost, float rawVelocity, int cooldown, Consumer<ItemAttributeModifiers.Builder> consumer) {
        this(new Item.Properties().stacksTo(1), rarity, factory, damage, manaCost, rawVelocity, cooldown);
        this.addAttributeModifiers(consumer);
    }

    public ManaStaffItem(ModRarity rarity, ProjectileFactory<E> factory, float damage, int manaCost, float rawVelocity, int cooldown, double critChance) {
        this(new Item.Properties().stacksTo(1), rarity, factory, damage, manaCost, rawVelocity, cooldown);
        if (critChance == 0.0) {
            return;
        }
        this.addAttributeModifiers(builder -> builder.add(TCAttributes.getCriticalChance(), new AttributeModifier(ID, critChance, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND));
    }

    public int getEnchantmentValue(ItemStack stack) {
        return 20;
    }

    public UseAnim getUseAnimation(ItemStack itemStack) {
        return UseAnim.BLOCK;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand usedHand) {
        ServerPlayer serverPlayer;
        ItemStack itemStack = player.getItemInHand(usedHand);
        if (player instanceof ServerPlayer && this.couldShoot(serverPlayer = (ServerPlayer)player, itemStack)) {
            serverPlayer.awardStat(Stats.ITEM_USED.get((Object)this));
            DamageSettableProjectile projectile = (DamageSettableProjectile)((Object)this.factory.create(serverPlayer));
            this.beforeShoot(serverPlayer, itemStack, projectile);
            level.addFreshEntity((Entity)projectile);
            this.afterShoot(serverPlayer, itemStack, projectile);
            this.rayTrace(serverPlayer, itemStack, projectile);
        }
        return InteractionResultHolder.success((Object)itemStack);
    }

    protected boolean couldShoot(ServerPlayer player, ItemStack itemStack) {
        return PlayerUtils.extractMana(player, itemStack, () -> PrefixUtils.calculateManaCost(itemStack, this.manaCost));
    }

    protected void beforeShoot(ServerPlayer player, ItemStack itemStack, E projectile) {
        ((DamageSettableProjectile)((Object)projectile)).setDamage(this.damage);
        ((DamageSettableProjectile)((Object)projectile)).setDefaultVelocity(this.velocity);
        projectile.setOwner((Entity)player);
        projectile.shootFromRotation((Entity)player, player.getXRot(), player.getYRot(), 0.0f, this.velocity, 0.0f);
    }

    protected void afterShoot(ServerPlayer player, ItemStack itemStack, E projectile) {
        if (this.cooldown > 0) {
            player.getCooldowns().addCooldown((Item)this, this.cooldown);
        }
        player.level().playSound(null, player.getX(), player.getY(), player.getZ(), (SoundEvent)ModSoundEvents.REGULAR_STAFF_SHOOT.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
    }

    protected void rayTrace(ServerPlayer player, ItemStack itemStack, E projectile) {
        Vec3 viewVector = player.getViewVector(1.0f);
        Vec3 startVec = new Vec3(player.getX(), player.getEyeY() - 0.1, player.getZ());
        Vec3 endVec = startVec.add(viewVector.scale((double)this.velocity));
        for (Entity victim : player.level().getEntities((Entity)player, new AABB(startVec, endVec), arg_0 -> projectile.canHitEntity(arg_0))) {
            if (victim.getBoundingBox().inflate(0.3).clip(startVec, endVec).isEmpty()) continue;
            player.setLastHurtMob(victim);
            if (victim instanceof PartEntity) {
                PartEntity partEntity = (PartEntity)victim;
                victim = partEntity.getParent();
            }
            victim.hurt(((DamageSettableProjectile)((Object)projectile)).getDamageSource(), ((DamageSettableProjectile)((Object)projectile)).getCalculatedDamage());
        }
    }

    public boolean isEnchantable(ItemStack stack) {
        return stack.getMaxStackSize() == 1;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        tooltipComponents.add((Component)Component.translatable((String)"tooltip.confluence.attack_damage", (Object[])new Object[]{Float.valueOf(this.damage)}).withStyle(ChatFormatting.GRAY));
        tooltipComponents.add((Component)Component.translatable((String)"tooltip.confluence.mana_cost", (Object[])new Object[]{this.manaCost}).withStyle(ChatFormatting.GRAY));
        tooltipComponents.add((Component)Component.translatable((String)"tooltip.confluence.velocity", (Object[])new Object[]{Float.valueOf(this.velocity)}).withStyle(ChatFormatting.GRAY));
        tooltipComponents.add((Component)Component.translatable((String)"tooltip.confluence.cooldown", (Object[])new Object[]{this.cooldown}).withStyle(ChatFormatting.GRAY));
    }

    @FunctionalInterface
    public static interface ProjectileFactory<E extends Projectile> {
        public E create(ServerPlayer var1);
    }
}

