/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.item.mana;

import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.level.Level;
import org.confluence.lib.common.component.ModRarity;
import org.confluence.mod.common.entity.projectile.mana.WaterStreamProjectile;
import org.confluence.mod.common.init.ModSoundEvents;
import org.confluence.mod.common.item.mana.ManaStaffItem;
import org.confluence.mod.util.PlayerUtils;
import org.confluence.mod.util.PrefixUtils;

public class AquaScepterItem
extends ManaStaffItem<WaterStreamProjectile> {
    public AquaScepterItem() {
        super(ModRarity.GREEN, WaterStreamProjectile::new, 11.0f, 7, 37.5f, 0, 0.04);
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return 72000;
    }

    @Override
    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand usedHand) {
        player.awardStat(Stats.ITEM_USED.get((Object)this));
        return ItemUtils.startUsingInstantly((Level)level, (Player)player, (InteractionHand)usedHand);
    }

    @Override
    protected boolean couldShoot(ServerPlayer player, ItemStack itemStack) {
        return PlayerUtils.extractMana(player, itemStack, () -> PrefixUtils.calculateManaCost(itemStack, (float)this.manaCost / 3.0f));
    }

    public void onUseTick(Level level, LivingEntity livingEntity, ItemStack stack, int remainingUseDuration) {
        ServerPlayer player;
        if (remainingUseDuration % 3 == 0 && livingEntity instanceof ServerPlayer && this.couldShoot(player = (ServerPlayer)livingEntity, stack)) {
            WaterStreamProjectile projectile = (WaterStreamProjectile)((Object)this.factory.create(player));
            this.beforeShoot(player, stack, projectile);
            level.addFreshEntity((Entity)projectile);
            if (remainingUseDuration % 6 == 0) {
                player.level().playSound(null, player.getX(), player.getY(), player.getZ(), (SoundEvent)ModSoundEvents.REGULAR_STAFF_SHOOT_3.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
            }
        }
    }
}

