/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.item.hook;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.confluence.lib.ConfluenceMagicLib;
import org.confluence.lib.common.component.ModRarity;
import org.confluence.lib.util.LibUtils;
import org.confluence.mod.common.attachment.ExtraInventory;
import org.confluence.mod.common.entity.hook.AbstractHookEntity;
import org.confluence.mod.common.item.hook.IHookFastThrow;
import org.jetbrains.annotations.Nullable;

public class BaseHookItem
extends Item {
    protected final int amount;
    protected final float range;
    protected final float velocity;
    protected final HookType type;
    protected final HookEntityFactory factory;

    public BaseHookItem(Item.Properties pProperties, ModRarity rarity, int amount, float range, float velocity, HookType type, HookEntityFactory factory) {
        super(pProperties.component(ConfluenceMagicLib.MOD_RARITY, (Object)rarity).stacksTo(1));
        this.amount = amount;
        this.range = range;
        this.velocity = velocity;
        this.type = type;
        this.factory = factory;
    }

    public BaseHookItem(ModRarity rarity, int amount, float range, float velocity, HookType type, HookEntityFactory factory) {
        this(new Item.Properties(), rarity, amount, range, velocity, type, factory);
    }

    public int getHookAmount() {
        return this.amount;
    }

    public float getHookRange() {
        return this.range;
    }

    public float getHookVelocity() {
        return this.velocity;
    }

    public AbstractHookEntity getHook(ItemStack itemStack, BaseHookItem item, Player player, Level level) {
        return this.factory.create(itemStack, item, player, level);
    }

    public HookType getHookType() {
        return this.type;
    }

    public boolean canHook(ServerLevel level, ExtraInventory extraInventory, ItemStack itemStack) {
        ListTag list = LibUtils.getItemStackNbt((ItemStack)itemStack).getList("hooks", 10);
        if (!list.isEmpty()) {
            list.removeIf(tag -> BaseHookItem.getHookEntity(tag, (Level)level) == null);
        }
        LibUtils.updateItemStackNbt((ItemStack)itemStack, tag -> {
            tag.put("hooks", (Tag)list);
            extraInventory.setChanged();
        });
        if (this instanceof IHookFastThrow) {
            return list.size() <= this.getHookAmount();
        }
        return list.isEmpty() || list.stream().allMatch(tag -> {
            AbstractHookEntity hookEntity = BaseHookItem.getHookEntity(tag, (Level)level);
            return hookEntity == null || hookEntity.getHookState() == AbstractHookEntity.HookState.HOOKED;
        });
    }

    public void onUnequip(ServerPlayer serverPlayer, ItemStack newStack, ItemStack stack) {
        Tag tag;
        if (!ItemStack.isSameItem((ItemStack)newStack, (ItemStack)stack) && (tag = LibUtils.getItemStackNbtNoCopy((ItemStack)stack).get("hooks")) instanceof ListTag) {
            ListTag list = (ListTag)tag;
            BaseHookItem.discardAllHooks(list, serverPlayer.serverLevel());
        }
    }

    public static void discardAllHooks(ListTag list, ServerLevel level) {
        if (!list.isEmpty()) {
            list.removeIf(tag -> {
                AbstractHookEntity hookEntity = BaseHookItem.getHookEntity(tag, (Level)level);
                if (hookEntity != null) {
                    hookEntity.discard();
                }
                return true;
            });
        }
    }

    @Nullable
    public static AbstractHookEntity getHookEntity(Tag tag, Level level) {
        AbstractHookEntity hookEntity;
        Entity entity = level.getEntity(((CompoundTag)tag).getInt("id"));
        return entity instanceof AbstractHookEntity ? (hookEntity = (AbstractHookEntity)entity) : null;
    }

    public static boolean hasAnyHooked(Player player) {
        ItemStack hook = ExtraInventory.of((LivingEntity)player).getHook(false);
        if (hook.isEmpty()) {
            return false;
        }
        CompoundTag nbt = LibUtils.getItemStackNbtIfPresent((ItemStack)hook);
        if (nbt == null) {
            return false;
        }
        ListTag list = nbt.getList("hooks", 10);
        return !list.isEmpty() && list.stream().anyMatch(tag -> {
            AbstractHookEntity hookEntity = BaseHookItem.getHookEntity(tag, player.level());
            return hookEntity != null && hookEntity.getHookState() == AbstractHookEntity.HookState.HOOKED;
        });
    }

    public static enum HookType {
        SINGLE,
        SIMULTANEOUS,
        INDIVIDUAL;

    }

    @FunctionalInterface
    public static interface HookEntityFactory {
        public AbstractHookEntity create(ItemStack var1, BaseHookItem var2, Player var3, Level var4);
    }
}

