/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.item.gun;

import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.confluence.lib.common.component.ModRarity;
import org.confluence.lib.util.LibUtils;
import org.confluence.mod.common.init.ModDamageTypes;
import org.confluence.mod.common.init.item.ArmorItems;
import org.confluence.mod.common.item.gun.ManaGunItem;
import org.confluence.mod.util.AchievementUtils;
import org.confluence.terra_curio.api.primitive.ValueType;
import org.confluence.terra_curio.common.entity.BeeProjectile;
import org.confluence.terra_curio.common.init.TCItems;
import org.confluence.terra_curio.util.TCUtils;

public class BeeGunItem
extends ManaGunItem {
    public BeeGunItem(Item.Properties properties) {
        super(properties, 4, 4.6f, 1.0f, 0.01f, 0.04f, 2, 1.5f, ModRarity.GREEN, 5);
    }

    @Override
    public void shoot(ServerPlayer player, ItemStack bullet, ItemStack gunStack) {
        super.shoot(player, bullet, gunStack);
        BeeGunItem.notTheBees((Player)player);
    }

    protected void prepareBulletEntity(List<Projectile> baseBulletEntities, ServerPlayer player, ItemStack bullet, ItemStack gun, float damage, float knockback, float velocity, int penetrate, float inaccuracy) {
        boolean hasHivePack = TCUtils.hasType((LivingEntity)player, (ValueType)TCItems.HIVE$PACK);
        int times = ThreadLocalRandom.current().nextInt(1, hasHivePack ? 5 : 4);
        for (int i = 0; i < times; ++i) {
            BeeProjectile beeProjectile = new BeeProjectile(this, (Level)player.serverLevel(), (LivingEntity)player, hasHivePack && player.getRandom().nextBoolean()){

                protected DamageSource getDamageSource() {
                    return ModDamageTypes.of(this.level(), ModDamageTypes.MAGICAL_PROJECTILE, (Entity)this, this.getOwner());
                }
            };
            beeProjectile.setPos(player.getX(), player.getEyeY(), player.getZ());
            beeProjectile.shootFromRotation((Entity)player, player.getXRot(), player.getYRot(), 0.0f, velocity, inaccuracy);
            baseBulletEntities.add((Projectile)beeProjectile);
        }
    }

    private static void notTheBees(Player player) {
        CompoundTag data = LibUtils.getOrCreatePersistedData((Player)player);
        if (!data.getBoolean("confluence:not_the_bees") && (player.getItemBySlot(EquipmentSlot.HEAD).is((Item)ArmorItems.BEE_HELMET.get()) || player.getItemBySlot(EquipmentSlot.CHEST).is((Item)ArmorItems.BEE_CHESTPLATE.get()) || player.getItemBySlot(EquipmentSlot.LEGS).is((Item)ArmorItems.BEE_LEGGINGS.get()) || player.getItemBySlot(EquipmentSlot.FEET).is((Item)ArmorItems.BEE_BOOTS.get()))) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            AdvancementHolder advancement = serverPlayer.server.getAdvancements().get(AchievementUtils.asAchievement("not_the_bees"));
            if (advancement != null) {
                serverPlayer.getAdvancements().award(advancement, "never");
            }
            data.putBoolean("confluence:not_the_bees", true);
        }
    }
}

