/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.item.food;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import org.apache.commons.lang3.function.TriConsumer;
import org.confluence.lib.ConfluenceMagicLib;
import org.confluence.lib.common.component.ModRarity;
import org.confluence.lib.common.item.TooltipItem;
import org.confluence.mod.common.init.ModSecretSeeds;
import org.confluence.mod.common.init.item.FoodItems;

public class BaseFoodItem
extends Item {
    protected final Builder builder;

    public BaseFoodItem(Builder builder) {
        super(builder.properties);
        this.builder = builder;
    }

    public Item.Properties getProperties() {
        return this.builder.properties;
    }

    public static Builder builder() {
        return new Builder(new Item.Properties());
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return this.builder.duration.apply(stack);
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return this.builder.useAnim.apply(stack);
    }

    public SoundEvent getDrinkingSound() {
        return this.builder.drinkingSoundType.apply(null);
    }

    public SoundEvent getEatingSound() {
        return this.builder.eatingSoundType.apply(null);
    }

    public ItemStack finishUsingItem(ItemStack stack, Level level, LivingEntity livingEntity) {
        ServerLevel serverLevel;
        if (stack.is(FoodItems.CHERRY) && level instanceof ServerLevel && ModSecretSeeds.NO_TRAPS.match(serverLevel = (ServerLevel)level) && level.random.nextFloat() < 0.7f) {
            level.explode(null, livingEntity.getX(), livingEntity.getY(), livingEntity.getZ(), 2.5f, false, Level.ExplosionInteraction.MOB);
        }
        if (this.builder.finishUsingCallback != null) {
            this.builder.finishUsingCallback.accept((Object)stack, (Object)level, (Object)livingEntity);
        }
        return super.finishUsingItem(stack, level, livingEntity);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        tooltipComponents.addAll(this.builder.tooltips);
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
    }

    public static class Builder {
        private final Item.Properties properties;
        private Function<ItemStack, Integer> duration = duration -> 0;
        private Function<Void, SoundEvent> drinkingSoundType = sound -> SoundEvents.EMPTY;
        private Function<Void, SoundEvent> eatingSoundType = sound -> SoundEvents.EMPTY;
        private Function<ItemStack, UseAnim> useAnim = useAnim -> UseAnim.NONE;
        private final List<Component> tooltips = new ArrayList<Component>();
        private TriConsumer<ItemStack, Level, LivingEntity> finishUsingCallback;

        public Builder() {
            this.properties = new Item.Properties();
        }

        public Builder(Item.Properties properties) {
            this.properties = properties;
        }

        public void isFireResistant() {
            this.properties.fireResistant();
        }

        public Builder rarity(ModRarity rarity) {
            this.properties.component(ConfluenceMagicLib.MOD_RARITY, (Object)rarity);
            return this;
        }

        public Builder food(FoodProperties foodProperties) {
            this.properties.food(foodProperties);
            return this;
        }

        public Builder duration(Function<ItemStack, Integer> duration) {
            this.duration = duration;
            return this;
        }

        public Builder useAnim(Function<ItemStack, UseAnim> useAnim) {
            this.useAnim = useAnim;
            return this;
        }

        public Builder drinkingSound(Function<Void, SoundEvent> drinkingSoundType) {
            this.drinkingSoundType = drinkingSoundType;
            return this;
        }

        public Builder eatingSound(Function<Void, SoundEvent> eatingSoundType) {
            this.eatingSoundType = eatingSoundType;
            return this;
        }

        public Builder tooltip(String id, int lineCount, ChatFormatting chatFormatting) {
            this.tooltips.addAll(TooltipItem.getTooltipsFromString((String)id, (int)lineCount, (ChatFormatting)chatFormatting));
            return this;
        }

        public void setFinishUsingCallback(TriConsumer<ItemStack, Level, LivingEntity> finishUsingCallback) {
            this.finishUsingCallback = finishUsingCallback;
        }

        public Item.Properties getProperties() {
            return this.properties;
        }

        public Builder stackTo(int stack) {
            this.properties.stacksTo(stack);
            return this;
        }

        public BaseFoodItem build() {
            return new BaseFoodItem(this);
        }
    }

    public static class BItem
    extends BlockItem {
        public BItem(Block block, Item.Properties properties) {
            super(block, properties);
        }
    }
}

