/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.item.flail;

import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.confluence.mod.common.entity.projectile.FlailBall;
import org.confluence.mod.mixed.IPlayer;
import org.jetbrains.annotations.NotNull;

@ParametersAreNonnullByDefault
public class FlailItem
extends Item {
    public final float damage;
    public final ParticleOptions particle;
    public final MobEffect effect;
    public final double chance;

    public FlailItem(float damage, ParticleOptions particle, MobEffect effect, double chance) {
        super(new Item.Properties().stacksTo(1));
        this.damage = damage;
        this.particle = particle;
        this.effect = effect;
        this.chance = chance;
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return 12000;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand usedHand) {
        player.startUsingItem(usedHand);
        ItemStack itemstack = player.getItemInHand(usedHand);
        IPlayer fp = IPlayer.of(player);
        FlailBall flail = fp.confluence$getFlailBall();
        if (flail == null) {
            flail = new FlailBall(player.level(), (Entity)player, usedHand, this);
            player.level().addFreshEntity((Entity)flail);
            fp.confluence$setFlailBall(flail);
        } else if (flail.getPhase() != 3) {
            flail.setPhase(4);
        }
        return InteractionResultHolder.success((Object)itemstack);
    }

    public void releaseUsing(ItemStack stack, Level level, LivingEntity living, int timeCharged) {
        super.releaseUsing(stack, level, living, timeCharged);
        if (!(living instanceof IPlayer)) {
            return;
        }
        IPlayer player = (IPlayer)living;
        FlailBall flail = player.confluence$getFlailBall();
        if (flail == null) {
            return;
        }
        int phase = flail.getPhase();
        Player owner = (Player)player;
        if (phase == 0) {
            float rotModify = owner.getItemInHand(InteractionHand.MAIN_HAND).is((Item)this) ? -3.0f : 3.0f;
            flail.setPhase(1);
            flail.setPos(flail.position().add(0.0, 1.0, 0.0));
            Vec3 direction = Vec3.directionFromRotation((float)(owner.getXRot() - 3.0f), (float)(owner.getYRot() + rotModify)).scale(3.0);
            flail.setDeltaMovement(direction.add(owner.getDeltaMovement()));
        } else {
            flail.setPhase(3);
        }
    }
}

