/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.item.crossbow;

import java.lang.runtime.SwitchBootstraps;
import java.util.Arrays;
import java.util.stream.IntStream;
import net.minecraft.util.RandomSource;
import org.jetbrains.annotations.NotNull;

public interface IRandomCount {
    public static final IRandomCount DEFAULT = IRandomCount.create(1.0f);
    public static final IRandomCount DEFAULT_EMPTY = IRandomCount.create(0.0f);

    public float getCount(@NotNull RandomSource var1);

    public float getMaxCount();

    public float getMinCount();

    default public boolean isEmpty() {
        return this.getMinCount() == 0.0f && this.getMaxCount() == 0.0f;
    }

    default public String getString() {
        return "";
    }

    public static String getString(IRandomCount randomCount) {
        IRandomCount iRandomCount = randomCount;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ArrayRandom.class, NonRandom.class, RangeRandom.class}, (Object)iRandomCount, n)) {
            case 0: {
                ArrayRandom random = (ArrayRandom)iRandomCount;
                StringBuilder sb = new StringBuilder();
                for (float number : random.getNumbers()) {
                    sb.append(number).append(", ");
                }
                return sb.toString();
            }
            case 1: {
                NonRandom nonRandom = (NonRandom)iRandomCount;
                return String.valueOf(nonRandom.getCount());
            }
            case 2: {
                RangeRandom random = (RangeRandom)iRandomCount;
                return random.getMinCount() + "~" + random.getMaxCount();
            }
            case -1: {
                return "";
            }
        }
        return randomCount.getString();
    }

    public static boolean is(IRandomCount randomCount, float i) {
        IRandomCount iRandomCount = randomCount;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ArrayRandom.class, NonRandom.class, RangeRandom.class}, (Object)iRandomCount, n)) {
            case 0: {
                ArrayRandom random = (ArrayRandom)iRandomCount;
                if (random.getNumbers().length > 1) {
                    return false;
                }
                return random.getNumbers()[0] == i;
            }
            case 1: {
                NonRandom nonRandom = (NonRandom)iRandomCount;
                return nonRandom.getCount() == i;
            }
            case 2: {
                RangeRandom random = (RangeRandom)iRandomCount;
                return random.getMinCount() == i && random.getMaxCount() == i;
            }
        }
        return false;
    }

    public static IRandomCount create(float min, float max) {
        return new RangeRandom(min, max);
    }

    public static IRandomCount create(float[] number) {
        return new ArrayRandom(number);
    }

    public static IRandomCount create(float number) {
        return new NonRandom(number);
    }

    public static class ArrayRandom
    extends RandomCount {
        private final float[] numbers;

        public ArrayRandom(float ... numbers) {
            this.numbers = numbers;
        }

        @Override
        public float getCount(@NotNull RandomSource randomSource) {
            return this.numbers[randomSource.nextInt(this.numbers.length)];
        }

        @Override
        public float getMaxCount() {
            return (float)Arrays.stream(this.getDoubleArray()).max().orElse(0.0);
        }

        @Override
        public float getMinCount() {
            return (float)Arrays.stream(this.getDoubleArray()).min().orElse(0.0);
        }

        private double[] getDoubleArray() {
            return IntStream.range(0, this.numbers.length).mapToDouble(i -> this.numbers[i]).toArray();
        }

        public float[] getNumbers() {
            return this.numbers;
        }

        @Override
        public String toString() {
            return "RandomCount{numbers=" + Arrays.toString(this.numbers) + "}";
        }
    }

    public static final class NonRandom
    extends RandomCount {
        private final float count;

        public NonRandom(float count) {
            this.count = count;
        }

        @Override
        public float getCount(@NotNull RandomSource randomSource) {
            return this.count;
        }

        public float getCount() {
            return this.count;
        }

        @Override
        public float getMaxCount() {
            return this.count;
        }

        @Override
        public float getMinCount() {
            return this.count;
        }

        @Override
        public String toString() {
            return "RandomCount{count=" + this.count + "}";
        }
    }

    public static class RangeRandom
    extends RandomCount {
        private final float min;
        private final float max;

        public RangeRandom(float min, float max) {
            assert (min < max) : "min must less than max";
            this.min = min;
            this.max = max;
        }

        @Override
        public float getCount(@NotNull RandomSource randomSource) {
            return randomSource.nextFloat() * (this.max - this.min) + this.min;
        }

        @Override
        public float getMaxCount() {
            return this.max;
        }

        @Override
        public float getMinCount() {
            return this.min;
        }
    }

    public static abstract class RandomCount
    implements IRandomCount {
        public String toString() {
            return "RandomCount{min=" + this.getMinCount() + ", max=" + this.getMaxCount() + "}";
        }
    }
}

