/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.item.common;

import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.common.Tags;
import org.confluence.lib.common.component.ModRarity;
import org.confluence.lib.common.item.CustomRarityItem;
import org.confluence.mod.common.init.ModTiers;
import org.confluence.mod.common.init.item.ModItems;
import org.confluence.mod.common.item.tooltipcomponent.AltImageComponent;
import org.jetbrains.annotations.Nullable;

public class StaffOfRegrowth
extends CustomRarityItem {
    @Nullable
    private TooltipComponent component;

    public StaffOfRegrowth() {
        super(new Item.Properties().component(DataComponents.ATTRIBUTE_MODIFIERS, (Object)ModItems.createAttributes(ModTiers.PLATINUM, 3.0f - ModTiers.PLATINUM.getAttackDamageBonus() - 1.0f, -3.0f, builder -> {})).stacksTo(1), ModRarity.GREEN);
    }

    public Optional<TooltipComponent> getTooltipImage(ItemStack stack) {
        if (this.component == null) {
            this.component = AltImageComponent.of(stack.getItem());
        }
        return Optional.of(this.component);
    }

    public InteractionResult useOn(UseOnContext context) {
        return StaffOfRegrowth.useOnAction(context);
    }

    public static InteractionResult useOnAction(UseOnContext context) {
        Player player = context.getPlayer();
        Level level = context.getLevel();
        BlockPos pos = context.getClickedPos();
        BlockState state = level.getBlockState(pos);
        if (player != null && !level.isClientSide && state.is(Blocks.DIRT)) {
            level.setBlockAndUpdate(pos, Blocks.GRASS_BLOCK.defaultBlockState());
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public static void dropAndPlaceOnRightClick(Player player, ItemStack stack, BlockPos pos) {
        ServerLevel level = (ServerLevel)player.level();
        BlockState state = level.getBlockState(pos);
        if (!state.is(BlockTags.CROPS)) {
            return;
        }
        for (Property property : state.getProperties()) {
            block11: {
                IntegerProperty integerProperty;
                if (!(property instanceof IntegerProperty) || !"age".equals((integerProperty = (IntegerProperty)property).getName())) continue;
                int age = (Integer)state.getValue((Property)integerProperty);
                if (property.getPossibleValues().size() == age + 1) {
                    Item item;
                    ItemStack consumed = ItemStack.EMPTY;
                    List drops = Block.getDrops((BlockState)state, (ServerLevel)level, (BlockPos)pos, (BlockEntity)level.getBlockEntity(pos), (Entity)player, (ItemStack)stack);
                    StaffOfRegrowth.increaseDrops((Entity)player, stack, drops.stream());
                    for (ItemStack drop : drops) {
                        if (consumed.isEmpty() && (drop.is(Tags.Items.SEEDS) || drop.is(state.getBlock().asItem()))) {
                            consumed = drop.split(1);
                            if (drop.isEmpty()) continue;
                        }
                        Block.popResource((Level)level, (BlockPos)pos, (ItemStack)drop);
                    }
                    if (!consumed.isEmpty() && (item = consumed.getItem()) instanceof BlockItem) {
                        BlockItem blockItem = (BlockItem)item;
                        level.setBlockAndUpdate(pos, blockItem.getBlock().defaultBlockState());
                    } else {
                        level.removeBlock(pos, false);
                    }
                } else if (age > 0) {
                    List drops = Block.getDrops((BlockState)state, (ServerLevel)level, (BlockPos)pos, (BlockEntity)level.getBlockEntity(pos), (Entity)player, (ItemStack)stack);
                    StaffOfRegrowth.increaseDrops((Entity)player, stack, drops.stream());
                    for (ItemStack drop : drops) {
                        if (drop.is(Tags.Items.SEEDS)) {
                            Block.popResource((Level)level, (BlockPos)pos, (ItemStack)drop);
                            continue;
                        }
                        if (!drop.is(state.getBlock().asItem())) continue;
                        break block11;
                    }
                    level.setBlock(pos, (BlockState)state.setValue((Property)integerProperty, (Comparable)Integer.valueOf(0)), 2);
                }
            }
            player.swing(InteractionHand.MAIN_HAND, true);
            break;
        }
    }

    public static void increaseDrops(Entity breaker, ItemStack tool, Stream<ItemStack> drops) {
        Holder enchantment = breaker.level().holderOrThrow(Enchantments.FORTUNE);
        int l = tool.getTagEnchantments().getLevel(enchantment);
        drops.forEach(drop -> {
            int increase = breaker.getRandom().nextIntBetweenInclusive(0, 2);
            drop.grow(increase);
            for (int i = 0; i < l; ++i) {
                if (!breaker.getRandom().nextBoolean()) continue;
                drop.grow(1);
            }
        });
    }
}

