/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.item.common;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import org.confluence.mod.common.attachment.ChunkDropletsData;
import org.confluence.mod.network.s2c.DropletsSyncPacketS2C;
import org.jetbrains.annotations.Nullable;

public class MagicDropperItem
extends Item {
    @Nullable
    private final ParticleOptions particle;

    public MagicDropperItem(@Nullable ParticleOptions particle) {
        super(new Item.Properties().stacksTo(9999));
        this.particle = particle;
    }

    public InteractionResult useOn(UseOnContext context) {
        Player player;
        Level level = context.getLevel();
        if (!(level instanceof ServerLevel)) {
            return InteractionResult.SUCCESS;
        }
        ServerLevel level2 = (ServerLevel)level;
        BlockPos pos = context.getClickedPos();
        if (!context.isInside()) {
            pos = pos.relative(context.getClickedFace());
        }
        if ((player = context.getPlayer()) != null) {
            ChunkDropletsData data = ChunkDropletsData.of((Level)level2);
            ChunkPos chunkPos = new ChunkPos(pos);
            Map map = data.getDataMap().computeIfAbsent(chunkPos, c -> new HashMap());
            if (this.particle == null) {
                map.remove(pos);
            } else {
                map.put(pos, this.particle);
            }
            DropletsSyncPacketS2C.sendToPlayersTrackingChunk(level2, chunkPos, data.getDataMap(player, true));
            if (!player.hasInfiniteMaterials()) {
                context.getItemInHand().shrink(1);
            }
        }
        return InteractionResult.CONSUME;
    }
}

