/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.item.common;

import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BiomeTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.Tags;
import org.confluence.lib.common.component.ModRarity;
import org.confluence.lib.common.item.CustomRarityItem;
import org.confluence.lib.common.item.TooltipItem;
import org.confluence.lib.util.LibUtils;
import org.confluence.mod.network.c2s.ApplySelectionPacketC2S;
import org.confluence.mod.network.s2c.OpenSelectionsScreenPacketS2C;
import org.confluence.mod.util.OverworldUtils;
import org.jetbrains.annotations.Nullable;

public class MagicConch
extends CustomRarityItem
implements ApplySelectionPacketC2S.ISelectable<BlockPos> {
    public List<Component> tooltips = TooltipItem.getTooltipsFromString((String)"magic_conch", (int)1, (ChatFormatting)ChatFormatting.GRAY);

    public MagicConch(Item.Properties properties, ModRarity rarity) {
        super(properties, rarity);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        tooltipComponents.addAll(this.tooltips);
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
    }

    public InteractionResult useOn(UseOnContext context) {
        Player player = context.getPlayer();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (context.getHand() == InteractionHand.MAIN_HAND && this.checkAvailable(context)) {
                BlockPos clickedPos = context.getClickedPos();
                LibUtils.updateItemStackNbt((ItemStack)context.getItemInHand(), tag -> {
                    if (!tag.contains("pos1")) {
                        tag.put("pos1", NbtUtils.writeBlockPos((BlockPos)clickedPos));
                    } else if (!tag.contains("pos2")) {
                        tag.put("pos2", NbtUtils.writeBlockPos((BlockPos)clickedPos));
                    } else {
                        BlockPos pos1 = NbtUtils.readBlockPos((CompoundTag)tag, (String)"pos1").orElse(BlockPos.ZERO);
                        BlockPos pos2 = NbtUtils.readBlockPos((CompoundTag)tag, (String)"pos2").orElse(BlockPos.ZERO);
                        if (pos1.equals((Object)clickedPos)) {
                            tag.remove("pos1");
                        } else if (pos2.equals((Object)clickedPos)) {
                            tag.remove("pos2");
                        } else {
                            double distanceToPos2;
                            double distanceToPos1 = clickedPos.distSqr((Vec3i)pos1);
                            tag.put(distanceToPos1 > (distanceToPos2 = clickedPos.distSqr((Vec3i)pos2)) ? "pos2" : "pos1", NbtUtils.writeBlockPos((BlockPos)clickedPos));
                        }
                    }
                    serverPlayer.sendSystemMessage(this.successStoreMessage(clickedPos), false);
                });
            }
        }
        return InteractionResult.SUCCESS;
    }

    protected Component successStoreMessage(BlockPos pos) {
        return Component.translatable((String)"chat.confluence.magic_conch", (Object[])new Object[]{pos.toShortString()});
    }

    public InteractionResultHolder<ItemStack> use(Level pLevel, Player pPlayer, InteractionHand pUsedHand) {
        ItemStack itemStack = pPlayer.getItemInHand(pUsedHand);
        if (pPlayer instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)pPlayer;
            CompoundTag tag = LibUtils.getItemStackNbtNoCopy((ItemStack)itemStack);
            if (tag.get("pos1") != null || tag.get("pos2") != null) {
                Optional pos1 = NbtUtils.readBlockPos((CompoundTag)tag, (String)"pos1");
                Optional pos2 = NbtUtils.readBlockPos((CompoundTag)tag, (String)"pos2");
                OpenSelectionsScreenPacketS2C.sendToClient(serverPlayer, new Component[]{this.getMessage(pos1), this.getMessage(pos2)}, new boolean[]{pos1.isPresent(), pos2.isPresent()});
            }
        }
        return InteractionResultHolder.sidedSuccess((Object)itemStack, (boolean)pLevel.isClientSide);
    }

    protected Component getMessage(Optional<BlockPos> pos) {
        return Component.translatable((String)"selections.confluence.magic_conch", (Object[])new Object[]{pos.map(Vec3i::toShortString).orElse("unknown")});
    }

    protected boolean checkAvailable(UseOnContext pContext) {
        Level level = pContext.getLevel();
        Holder biome = level.getBiome(pContext.getClickedPos());
        return pContext.getClickedFace() == Direction.UP && level.dimension() == OverworldUtils.dimension() && (biome.is(BiomeTags.IS_OCEAN) || biome.is(BiomeTags.IS_BEACH) || biome.is(Tags.Biomes.IS_STONY_SHORES));
    }

    @Override
    @Nullable
    public BlockPos getSelected(byte index, ItemStack itemStack) {
        CompoundTag tag = LibUtils.getItemStackNbtNoCopy((ItemStack)itemStack);
        if (index == 0) {
            return NbtUtils.readBlockPos((CompoundTag)tag, (String)"pos1").orElse(null);
        }
        if (index == 1) {
            return NbtUtils.readBlockPos((CompoundTag)tag, (String)"pos2").orElse(null);
        }
        return null;
    }

    @Override
    public void applySelected(byte index, ItemStack itemStack, ServerPlayer serverPlayer) {
        BlockPos pos = this.getSelected(index, itemStack);
        if (pos != null) {
            serverPlayer.teleportTo((double)pos.getX() + 0.5, (double)pos.getY() + 1.0, (double)pos.getZ() + 0.5);
        }
    }
}

