/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.item.common;

import java.util.List;
import java.util.Objects;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.confluence.lib.common.component.ModRarity;
import org.confluence.lib.common.item.TooltipItem;
import org.confluence.mod.common.gameevent.GameEvent;
import org.confluence.mod.common.gameevent.GameEventSystem;
import org.confluence.mod.common.gameevent.LanternNightGameEvent;

public class GameEventItem
extends TooltipItem {
    private final ResourceKey<? extends GameEvent> key;

    public GameEventItem(Item.Properties properties, ModRarity rarity, List<Component> tooltips, ResourceKey<? extends GameEvent> key) {
        super(properties, rarity, tooltips);
        this.key = key;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand usedHand) {
        ItemStack stack = player.getItemInHand(usedHand);
        if (!level.isClientSide) {
            if (Objects.requireNonNull(GameEventSystem.INSTANCE.getEventInstance(this.key)).forceStart()) {
                if (!player.hasInfiniteMaterials()) {
                    stack.shrink(1);
                }
                LanternNightGameEvent.INSTANCE.forceEnd();
            }
            return InteractionResultHolder.consume((Object)stack);
        }
        return InteractionResultHolder.success((Object)stack);
    }
}

