/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.item.common;

import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.PacketDistributor;
import org.confluence.lib.common.component.ModRarity;
import org.confluence.lib.common.item.TooltipItem;
import org.confluence.mod.Confluence;
import org.confluence.mod.common.attachment.EverBeneficial;
import org.confluence.mod.common.attachment.ManaStorage;
import org.confluence.mod.common.attachment.PlayerSpecialData;
import org.confluence.mod.common.attachment.SoulStorage;
import org.confluence.mod.common.init.item.MinecartItems;
import org.confluence.mod.common.item.common.BaseMinecartItem;
import org.confluence.mod.network.s2c.SoulPacketS2C;
import org.confluence.mod.util.AchievementUtils;
import org.confluence.terra_curio.api.primitive.ValueType;
import org.confluence.terra_curio.common.init.TCItems;
import org.confluence.terra_curio.network.s2c.RightClickSubtractorPacketS2C;
import org.confluence.terra_curio.util.TCUtils;
import org.jetbrains.annotations.Nullable;

public class EverBeneficialItem
extends TooltipItem {
    public static final Post DO_NOTHING = (id, player, everBeneficial, isRespawn) -> {};
    public static final Beneficial LIFE_CRYSTAL = new Beneficial(Confluence.asResource("life_crystal"), EverBeneficial::increaseCrystals, (id, player, everBeneficial, isRespawn) -> {
        AttributeInstance attributeInstance;
        if (everBeneficial.isLifeCrystalsMaximum() && everBeneficial.isLifeFruitsMaximum() && ManaStorage.of((LivingEntity)player).isStarMaximum()) {
            AchievementUtils.awardAchievement(player, "topped_off");
        }
        if ((attributeInstance = player.getAttributes().getInstance(Attributes.MAX_HEALTH)) == null) {
            return;
        }
        attributeInstance.addOrReplacePermanentModifier(new AttributeModifier(id, (double)everBeneficial.getUsedLifeCrystals() * 4.0, AttributeModifier.Operation.ADD_VALUE));
        if (!isRespawn) {
            player.heal(4.0f);
        }
    });
    public static final Beneficial LIFE_FRUITS = new Beneficial(Confluence.asResource("life_fruit"), EverBeneficial::increaseFruits, (id, player, everBeneficial, isRespawn) -> {
        AttributeInstance attributeInstance = player.getAttributes().getInstance(Attributes.MAX_HEALTH);
        if (attributeInstance == null) {
            return;
        }
        attributeInstance.addOrReplacePermanentModifier(new AttributeModifier(id, (double)everBeneficial.getUsedLifeFruits(), AttributeModifier.Operation.ADD_VALUE));
        if (!isRespawn) {
            player.heal(1.0f);
        }
    });
    public static final Beneficial VITAL_CRYSTAL = new Beneficial(Confluence.asResource("vital_crystal"), EverBeneficial::setVitalCrystalUsed, DO_NOTHING);
    public static final Beneficial AEGIS_APPLE = new Beneficial(Confluence.asResource("aegis_apple"), EverBeneficial::setAegisAppleUsed, (id, player, everBeneficial, isRespawn) -> {
        AttributeInstance attributeInstance = player.getAttributes().getInstance(Attributes.ARMOR);
        if (attributeInstance == null) {
            return;
        }
        attributeInstance.addOrReplacePermanentModifier(new AttributeModifier(id, 4.0, AttributeModifier.Operation.ADD_VALUE));
    });
    public static final Beneficial AMBROSIA = new Beneficial(Confluence.asResource("ambrosia"), EverBeneficial::setAmbrosiaUsed, (id, player, everBeneficial, isRespawn) -> {
        byte value = (Byte)TCUtils.getValue((LivingEntity)player, (ValueType)TCItems.RIGHT$CLICK$DELAY$SUBSTRACTOR);
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new RightClickSubtractorPacketS2C((byte)Math.min(value + 1, 4)), (CustomPacketPayload[])new CustomPacketPayload[0]);
        AttributeInstance attributeInstance = player.getAttributes().getInstance(Attributes.BLOCK_BREAK_SPEED);
        if (attributeInstance == null) {
            return;
        }
        attributeInstance.addOrReplacePermanentModifier(new AttributeModifier(id, 0.05, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL));
    });
    public static final Beneficial GUMMY_WORM = new Beneficial(Confluence.asResource("gummy_worm"), EverBeneficial::setGummyWormUsed, DO_NOTHING);
    public static final Beneficial GALAXY_PEARL = new Beneficial(Confluence.asResource("galaxy_pearl"), EverBeneficial::setGalaxyPearlUsed, (id, player, everBeneficial, isRespawn) -> {
        AttributeInstance attributeInstance = player.getAttributes().getInstance(Attributes.LUCK);
        if (attributeInstance == null) {
            return;
        }
        attributeInstance.addOrReplacePermanentModifier(new AttributeModifier(id, 0.03, AttributeModifier.Operation.ADD_VALUE));
    });
    public static final Beneficial MINECART_UPGRADE_KIT = new Beneficial(Confluence.asResource("minecart_upgrade_kit"), EverBeneficial::setMinecartUpgradeKitUsed, (id, player, everBeneficial, isRespawn) -> player.drop(((BaseMinecartItem)((Object)((Object)MinecartItems.MECHANICAL_CART.get()))).getDefaultInstance(), true));
    public static final Beneficial ARTISAN_LOAF = new Beneficial(Confluence.asResource("artisan_loaf"), EverBeneficial::setArtisanLoafUsed, (id, player, everBeneficial, isRespawn) -> {
        AttributeInstance attributeInstance = player.getAttributes().getInstance(Attributes.BLOCK_INTERACTION_RANGE);
        if (attributeInstance == null) {
            return;
        }
        attributeInstance.addOrReplacePermanentModifier(new AttributeModifier(id, 4.0, AttributeModifier.Operation.ADD_VALUE));
    });
    public static final Beneficial FALLEN_SOUL_CORE = new Beneficial(Confluence.asResource("fallen_soul_core"), everBeneficial -> true, (id, player, everBeneficial, isRespawn) -> {
        if (!isRespawn) {
            everBeneficial.changeFallenSoulCore();
            PlayerSpecialData data = PlayerSpecialData.of((Player)player);
            boolean active = everBeneficial.getFallenSoulCore();
            data.setFallenSoulCoreActive(active);
            SoulStorage soulStorage = SoulStorage.of((LivingEntity)player);
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = player;
                PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new SoulPacketS2C(soulStorage.getMaxSoul(), soulStorage.getCurrentSoul(), active), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
    });
    private final Beneficial beneficial;
    @Nullable
    private final Supplier<SoundEvent> sound;

    public EverBeneficialItem(Item.Properties properties, ModRarity rarity, Beneficial beneficial, @Nullable Supplier<SoundEvent> sound, List<Component> tooltips) {
        super(properties, rarity, tooltips);
        this.beneficial = beneficial;
        this.sound = sound;
    }

    public EverBeneficialItem(ModRarity rarity, Beneficial beneficial, @Nullable Supplier<SoundEvent> sound, List<Component> tooltips) {
        super(new Item.Properties(), rarity, tooltips);
        this.beneficial = beneficial;
        this.sound = sound;
    }

    public EverBeneficialItem(ModRarity rarity, Beneficial beneficial, List<Component> tooltips) {
        super(new Item.Properties(), rarity, tooltips);
        this.beneficial = beneficial;
        this.sound = null;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand usedHand) {
        if (level.isClientSide && this.sound != null) {
            player.playSound(this.sound.get());
        }
        ItemStack itemStack = player.getItemInHand(usedHand);
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            EverBeneficial data = EverBeneficial.of((LivingEntity)player);
            if (this.beneficial.pre.test(data)) {
                this.beneficial.post.accept(this.beneficial.id, serverPlayer, data, false);
                CriteriaTriggers.CONSUME_ITEM.trigger(serverPlayer, itemStack);
                if (!player.hasInfiniteMaterials()) {
                    itemStack.shrink(1);
                }
            }
        }
        return InteractionResultHolder.sidedSuccess((Object)itemStack, (boolean)level.isClientSide);
    }

    public record Beneficial(ResourceLocation id, Predicate<EverBeneficial> pre, Post post) {
        public void recovery(EverBeneficial everBeneficial, Predicate<EverBeneficial> condition, ServerPlayer player) {
            if (condition.test(everBeneficial)) {
                this.post.accept(this.id, player, everBeneficial, true);
            }
        }
    }

    @FunctionalInterface
    public static interface Post {
        public void accept(ResourceLocation var1, ServerPlayer var2, EverBeneficial var3, boolean var4);
    }
}

