/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.item.common;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootTable;
import org.confluence.mod.common.component.LootComponent;
import org.confluence.mod.common.init.ModDataComponentTypes;
import org.confluence.mod.common.init.ModSoundEvents;

public class CrateBlockItem
extends BlockItem {
    private final List<Component> commonTooltips = this.createCommonTooltips();

    public CrateBlockItem(Block block, ResourceKey<LootTable> lootTable) {
        super(block, new Item.Properties().fireResistant().component(ModDataComponentTypes.LOOT.get(), (Object)new LootComponent(lootTable)));
    }

    private List<Component> createCommonTooltips() {
        ArrayList<Component> tooltips = new ArrayList<Component>();
        tooltips.add((Component)Component.translatable((String)"tooltip.item.confluence.crate.common.0").withStyle(ChatFormatting.GRAY));
        return tooltips;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        tooltipComponents.addAll(this.commonTooltips);
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack itemStack = player.getItemInHand(hand);
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (hand == InteractionHand.MAIN_HAND && !player.isCrouching() && LootComponent.open(serverPlayer, itemStack) && !serverPlayer.hasInfiniteMaterials()) {
                itemStack.shrink(1);
            }
        } else {
            player.playSound((SoundEvent)ModSoundEvents.TERRA_OPERATION.get(), 0.5f, 1.0f);
        }
        return InteractionResultHolder.success((Object)itemStack);
    }

    protected boolean canPlace(BlockPlaceContext pContext, BlockState pState) {
        return pContext.getPlayer() == null || pContext.getPlayer().isCrouching();
    }
}

