/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.item.common;

import java.util.List;
import java.util.function.Supplier;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import org.confluence.lib.ConfluenceMagicLib;
import org.confluence.lib.common.component.ModRarity;
import org.confluence.mod.common.init.ModSoundEvents;
import org.confluence.mod.common.init.ModTags;
import org.confluence.mod.common.init.item.ModItems;
import org.jetbrains.annotations.Nullable;

public class CoinItem
extends BlockItem {
    public static final int UPGRADES_COUNT = 100;
    public final Supplier<CoinItem> upgrade;

    public CoinItem(Block block, ModRarity rarity, @Nullable Supplier<CoinItem> upgrade, int maxStackSize) {
        super(block, new Item.Properties().fireResistant().stacksTo(maxStackSize).component(ConfluenceMagicLib.MOD_RARITY, (Object)rarity));
        this.upgrade = upgrade;
    }

    public static void onPickup(ItemStack itemStack, ItemEntity itemEntity) {
        if (itemStack.is(ModTags.Items.COINS)) {
            if (itemStack.is(ModItems.COPPER_COIN)) {
                itemEntity.playSound((SoundEvent)ModSoundEvents.COINS_SMALL.get());
            } else if (itemStack.is(ModItems.SILVER_COIN)) {
                itemEntity.playSound((SoundEvent)ModSoundEvents.COINS_MEDIUM.get());
            } else {
                itemEntity.playSound((SoundEvent)ModSoundEvents.COINS_LARGE.get());
            }
        }
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand usedHand) {
        ItemStack stack = player.getItemInHand(usedHand);
        if (player.isCrouching() && this.upgrade != null && stack.getCount() >= 100) {
            if (level.isClientSide) {
                player.playSound((SoundEvent)ModSoundEvents.TERRA_OPERATION.get());
            } else {
                if (!player.getInventory().add(this.upgrade.get().getDefaultInstance())) {
                    player.drop(this.upgrade.get().getDefaultInstance(), true);
                }
                stack.shrink(100);
            }
            return InteractionResultHolder.sidedSuccess((Object)stack, (boolean)level.isClientSide);
        }
        return InteractionResultHolder.pass((Object)stack);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        if (this.upgrade != null && stack.getCount() >= 100) {
            tooltipComponents.add((Component)Component.translatable((String)"tooltip.item.confluence.coin.0").withColor(0xAAAAAA));
        }
    }
}

