/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.item.common;

import java.util.List;
import java.util.function.Predicate;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ServerboundInteractPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.entity.PartEntity;
import org.confluence.lib.ConfluenceMagicLib;
import org.confluence.lib.common.component.ModRarity;
import org.confluence.lib.common.item.TooltipItem;
import org.confluence.lib.util.LibUtils;
import org.confluence.mod.common.data.map.BugNetEntityToItem;
import org.confluence.mod.common.init.item.ModItems;
import org.confluence.mod.common.item.common.EntityDisplayItem;

public class BugNetItem
extends TooltipItem {
    private final double maxSize;
    private final Predicate<LivingEntity> predicate;

    public BugNetItem(ModRarity rarity, List<Component> tooltips, double maxSize, Predicate<LivingEntity> predicate) {
        super(new Item.Properties().stacksTo(1), rarity, tooltips);
        this.maxSize = maxSize;
        this.predicate = predicate;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand usedHand) {
        ItemStack stack;
        block11: {
            LivingEntity interactionTarget;
            block13: {
                LivingEntity living;
                PartEntity part;
                Entity entity2;
                EntityHitResult entityHitResult;
                block12: {
                    LivingEntity living2;
                    AABB aabb;
                    stack = player.getItemInHand(usedHand);
                    if (usedHand != InteractionHand.MAIN_HAND) {
                        return InteractionResultHolder.pass((Object)stack);
                    }
                    double reach = 15.0;
                    double squared = Mth.square((double)reach);
                    Vec3 from = player.getEyePosition(1.0f);
                    HitResult hitResult = player.pick(reach, 1.0f, false);
                    double sqr = hitResult.getLocation().distanceToSqr(from);
                    if (hitResult.getType() != HitResult.Type.MISS) {
                        squared = sqr;
                        reach = Math.sqrt(sqr);
                    }
                    Vec3 viewVector = player.getViewVector(1.0f);
                    Vec3 to = from.add(viewVector.x * reach, viewVector.y * reach, viewVector.z * reach);
                    entityHitResult = ProjectileUtil.getEntityHitResult((Entity)player, (Vec3)from, (Vec3)to, (AABB)(aabb = player.getBoundingBox().expandTowards(viewVector.scale(reach)).inflate(1.0)), entity -> !entity.isSpectator() && entity.isPickable(), (double)squared);
                    if (entityHitResult == null || !(entityHitResult.getLocation().distanceToSqr(from) < sqr)) break block11;
                    entity2 = entityHitResult.getEntity();
                    if (!(entity2 instanceof LivingEntity)) break block12;
                    interactionTarget = living2 = (LivingEntity)entity2;
                    break block13;
                }
                entity2 = entityHitResult.getEntity();
                if (!(entity2 instanceof PartEntity) || !((entity2 = (part = (PartEntity)entity2).getParent()) instanceof LivingEntity)) break block11;
                interactionTarget = living = (LivingEntity)entity2;
            }
            if (player.isLocalPlayer()) {
                ((LocalPlayer)player).connection.send((Packet)ServerboundInteractPacket.createInteractionPacket((Entity)interactionTarget, (boolean)false, (InteractionHand)InteractionHand.MAIN_HAND));
            } else if (this.predicate.test(interactionTarget) && interactionTarget.getBoundingBox().getSize() <= this.maxSize) {
                ItemStack itemStack = BugNetEntityToItem.getItem((ServerPlayer)player, interactionTarget);
                if (itemStack == null) {
                    itemStack = ((EntityDisplayItem)((Object)ModItems.ENTITY_DISPLAY.get())).getDefaultInstance();
                    interactionTarget.setYRot(0.0f);
                    interactionTarget.setYHeadRot(0.0f);
                    interactionTarget.setYBodyRot(0.0f);
                    interactionTarget.setXRot(0.0f);
                    interactionTarget.stopRiding();
                    LibUtils.updateItemStackNbt((ItemStack)itemStack, arg_0 -> ((LivingEntity)interactionTarget).save(arg_0));
                    if (interactionTarget.hasCustomName()) {
                        itemStack.set(DataComponents.CUSTOM_NAME, (Object)interactionTarget.getCustomName());
                    }
                    itemStack.remove(ConfluenceMagicLib.MOD_RARITY);
                }
                if (!player.addItem(itemStack)) {
                    player.drop(itemStack, false);
                }
                interactionTarget.discard();
            }
        }
        return InteractionResultHolder.success((Object)stack);
    }
}

