/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.item.common;

import com.google.common.collect.Streams;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.confluence.lib.common.component.ModRarity;
import org.confluence.lib.common.item.TooltipItem;
import org.confluence.mod.common.gameevent.LanternNightGameEvent;
import org.confluence.terraentity.utils.TEUtils;

public class BossSummoningItem
extends TooltipItem {
    private final Predicate<Player> condition;
    private final Function<Level, Mob> factory;

    public BossSummoningItem(Predicate<Player> condition, Function<Level, Mob> factory, List<Component> tooltips) {
        super(new Item.Properties(), ModRarity.BLUE, tooltips);
        this.condition = condition;
        this.factory = factory;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand usedHand) {
        ItemStack itemStack = player.getItemInHand(usedHand);
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (this.condition.test(player)) {
                Mob mob = this.factory.apply(level);
                if (Streams.stream((Iterable)serverLevel.getAllEntities()).anyMatch(entity -> entity.getType() == mob.getType())) {
                    return InteractionResultHolder.fail((Object)itemStack);
                }
                if (!player.hasInfiniteMaterials()) {
                    itemStack.shrink(1);
                }
                mob.setPos(player.getX() + (double)Mth.randomBetweenInclusive((RandomSource)level.random, (int)-50, (int)50), player.getY(), player.getZ() + (double)Mth.randomBetweenInclusive((RandomSource)level.random, (int)-50, (int)50));
                if (TEUtils.internalSpawnEntity((Entity)mob, (ServerLevel)serverLevel)) {
                    serverLevel.addFreshEntityWithPassengers((Entity)mob);
                    LanternNightGameEvent.INSTANCE.forceEnd();
                }
            }
        }
        return InteractionResultHolder.success((Object)itemStack);
    }
}

