/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.item.common;

import java.util.function.BiFunction;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class BlockPlacingWandItem
extends BlockItem {
    @Nullable
    protected final TagKey<Block> targetBlock;
    protected final BiFunction<BlockPlaceContext, BlockState, BlockState> transferTo;

    public BlockPlacingWandItem(@Nullable TagKey<Block> targetBlock, Block transferTo) {
        super(transferTo, new Item.Properties().stacksTo(1));
        this.targetBlock = targetBlock;
        this.transferTo = (context, state) -> state;
    }

    public BlockPlacingWandItem(@Nullable TagKey<Block> targetBlock, Block defaultBLock, BiFunction<BlockPlaceContext, BlockState, BlockState> transferTo) {
        super(defaultBLock, new Item.Properties().stacksTo(1));
        this.targetBlock = targetBlock;
        this.transferTo = transferTo;
    }

    @Nullable
    public BlockPlaceContext updatePlacementContext(BlockPlaceContext context) {
        Player player = context.getPlayer();
        if (player == null) {
            return null;
        }
        ItemStack heldItem = context.getItemInHand();
        ItemStack offHandItem = player.getOffhandItem();
        if (this.isValidBlockItem(offHandItem, heldItem)) {
            return new BlockPlaceContext(context.getLevel(), player, context.getHand(), offHandItem, context.getHitResult());
        }
        for (ItemStack itemStack : player.getInventory().items) {
            if (!this.isValidBlockItem(itemStack, heldItem)) continue;
            return new BlockPlaceContext(context.getLevel(), player, context.getHand(), itemStack, context.getHitResult());
        }
        return null;
    }

    protected BlockState getPlacementState(BlockPlaceContext context) {
        return this.transferTo.apply(context, super.getPlacementState(context));
    }

    public String getDescriptionId() {
        return this.getOrCreateDescriptionId();
    }

    protected boolean isValidBlockItem(ItemStack itemStack, ItemStack heldItem) {
        if (itemStack.isEmpty() || itemStack == heldItem || itemStack.getItem() instanceof BlockPlacingWandItem) {
            return false;
        }
        Item item = itemStack.getItem();
        if (item instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            if (this.targetBlock == null) {
                return blockItem.getBlock() == this.getBlock();
            }
            return blockItem.getBlock().builtInRegistryHolder().is(this.targetBlock) && blockItem.getBlock() != this.getBlock();
        }
        return false;
    }
}

