/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.item.common;

import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.core.Holder;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.enchantment.Enchantment;
import org.confluence.lib.ConfluenceMagicLib;
import org.confluence.lib.common.component.ModRarity;
import org.confluence.mod.common.init.item.ModItems;
import org.confluence.mod.common.item.tooltipcomponent.AltImageComponent;
import org.confluence.mod.util.ModUtils;
import org.jetbrains.annotations.Nullable;

public class BasePickaxeItem
extends PickaxeItem {
    @Nullable
    private TooltipComponent component;
    private boolean hasImage;

    public BasePickaxeItem(Tier tier, float rawDamage, float rawSpeed, ModRarity rarity) {
        this(tier, rawDamage, rawSpeed, new Item.Properties(), rarity);
    }

    public BasePickaxeItem(Tier tier, float rawDamage, float rawSpeed, Item.Properties properties, ModRarity rarity) {
        super(tier, properties.component(ConfluenceMagicLib.MOD_RARITY, (Object)rarity).attributes(BasePickaxeItem.createAttributes((Tier)tier, (float)(rawDamage - tier.getAttackDamageBonus() - 1.0f), (float)(rawSpeed - 4.0f))));
    }

    public BasePickaxeItem(Tier tier, float rawDamage, float rawSpeed, Item.Properties properties, Consumer<ItemAttributeModifiers.Builder> consumer, ModRarity rarity) {
        super(tier, properties.component(ConfluenceMagicLib.MOD_RARITY, (Object)rarity).attributes(ModItems.createAttributes(tier, rawDamage - tier.getAttackDamageBonus() - 1.0f, rawSpeed - 4.0f, consumer)));
    }

    public BasePickaxeItem hasImage() {
        this.hasImage = true;
        return this;
    }

    public Optional<TooltipComponent> getTooltipImage(ItemStack stack) {
        if (this.component == null && this.hasImage) {
            this.component = AltImageComponent.of(stack.getItem());
        }
        return Optional.ofNullable(this.component);
    }

    public boolean supportsEnchantment(ItemStack stack, Holder<Enchantment> enchantment) {
        return ModUtils.supportsEnchantment(stack, enchantment);
    }
}

