/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.item.common;

import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import org.confluence.lib.ConfluenceMagicLib;
import org.confluence.lib.common.component.ModRarity;
import org.confluence.mod.common.init.ModTags;
import org.confluence.mod.common.init.item.ModItems;
import org.confluence.mod.common.item.tooltipcomponent.AltImageComponent;
import org.confluence.mod.util.ModUtils;
import org.jetbrains.annotations.Nullable;

public class BaseHammerItem
extends DiggerItem {
    @Nullable
    private TooltipComponent component;
    private boolean hasImage;

    public BaseHammerItem(Tier tier, float rawDamage, float rawSpeed, ModRarity rarity) {
        this(tier, rawDamage, rawSpeed, new Item.Properties(), rarity);
    }

    public BaseHammerItem(Tier tier, float rawDamage, float rawSpeed, Item.Properties properties, ModRarity rarity) {
        super(tier, ModTags.Blocks.MINEABLE_WITH_HAMMER, properties.component(ConfluenceMagicLib.MOD_RARITY, (Object)rarity).component(DataComponents.ATTRIBUTE_MODIFIERS, (Object)BaseHammerItem.createAttributes((Tier)tier, (float)(rawDamage - tier.getAttackDamageBonus() - 1.0f), (float)(rawSpeed - 4.0f))));
    }

    public BaseHammerItem(Tier tier, float rawDamage, float rawSpeed, Item.Properties properties, Consumer<ItemAttributeModifiers.Builder> consumer, ModRarity rarity) {
        super(tier, ModTags.Blocks.MINEABLE_WITH_HAMMER, properties.component(ConfluenceMagicLib.MOD_RARITY, (Object)rarity).component(DataComponents.ATTRIBUTE_MODIFIERS, (Object)ModItems.createAttributes(tier, rawDamage - tier.getAttackDamageBonus() - 1.0f, rawSpeed - 4.0f, consumer)));
    }

    public BaseHammerItem hasImage() {
        this.hasImage = true;
        return this;
    }

    public Optional<TooltipComponent> getTooltipImage(ItemStack stack) {
        if (this.component == null && this.hasImage) {
            this.component = AltImageComponent.of(stack.getItem());
        }
        return Optional.ofNullable(this.component);
    }

    public boolean supportsEnchantment(ItemStack stack, Holder<Enchantment> enchantment) {
        return ModUtils.supportsEnchantment(stack, enchantment);
    }

    public boolean mineBlock(ItemStack stack, Level level, BlockState state, BlockPos pos, LivingEntity entity) {
        BaseHammerItem.hammerMineBlock(stack, level, state, pos, entity);
        return true;
    }

    public static void hammerMineBlock(ItemStack stack, Level level, BlockState state, BlockPos pos, LivingEntity entity) {
        if (level.isClientSide) {
            return;
        }
        int destroyCount = 1;
        if (entity instanceof Player) {
            Player player = (Player)entity;
            BlockHitResult picked = (BlockHitResult)player.pick(10.0, 1.0f, true);
            boolean xOff = true;
            boolean yOff = true;
            boolean zOff = true;
            switch (picked.getDirection()) {
                case NORTH: 
                case SOUTH: {
                    zOff = false;
                    break;
                }
                case WEST: 
                case EAST: {
                    xOff = false;
                    break;
                }
                default: {
                    yOff = false;
                }
            }
            destroyCount += BaseHammerItem.iteForBlocks(level, player, pos, xOff, yOff, zOff, state.getDestroyProgress(player, (BlockGetter)level, pos) * 1.5f, stack);
            if (state.getDestroyProgress(player, (BlockGetter)level, pos) != 0.0f) {
                stack.hurtAndBreak(destroyCount, entity, EquipmentSlot.MAINHAND);
            }
        }
    }

    public static int iteForBlocks(Level level, Player player, BlockPos pos, boolean xOff, boolean yOff, boolean zOff, float speedOff, ItemStack stack) {
        Stream posStream = BlockPos.betweenClosedStream((BlockPos)pos.offset(xOff ? 1 : 0, yOff ? 1 : 0, zOff ? 1 : 0), (BlockPos)pos.offset(xOff ? -1 : 0, yOff ? -1 : 0, zOff ? -1 : 0));
        return (int)posStream.filter(pos1 -> !pos1.equals((Object)pos)).filter(pos1 -> BaseHammerItem.applyBlockDestroy(level, pos1, player, speedOff, stack)).count();
    }

    public static boolean applyBlockDestroy(Level level, BlockPos pos, Player player, float speedOff, ItemStack stack) {
        BlockState targetState = level.getBlockState(pos);
        if (targetState.isAir() || targetState.liquid()) {
            return false;
        }
        float targetSpeed = targetState.getDestroySpeed((BlockGetter)level, pos);
        boolean flag1 = targetState.canHarvestBlock((BlockGetter)level, pos, player);
        boolean flag2 = speedOff > 0.0f ? targetSpeed >= 0.0f && speedOff >= targetSpeed : targetSpeed >= speedOff;
        boolean flag3 = player.hasInfiniteMaterials();
        if (flag1 && flag2 || flag3) {
            level.destroyBlock(pos, false, (Entity)player);
            if (flag1) {
                targetState.getBlock().playerDestroy(level, player, pos, targetState, targetState.hasBlockEntity() ? level.getBlockEntity(pos) : null, stack);
            }
            return true;
        }
        return false;
    }

    public boolean canDisableShield(ItemStack stack, ItemStack shield, LivingEntity entity, LivingEntity attacker) {
        return true;
    }
}

