/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.item.arrow;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.Unbreakable;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.confluence.lib.ConfluenceMagicLib;
import org.confluence.lib.common.component.ModRarity;
import org.confluence.mod.api.ITerraArrowProjectileWeaponItem;
import org.confluence.mod.common.entity.projectile.range.arrow.BaseArrowEntity;
import org.confluence.mod.common.init.ModEntities;
import org.confluence.terraentity.data.component.EffectStrategyComponent;
import org.confluence.terraentity.init.TEDataComponentTypes;
import org.confluence.terraentity.registries.hit_effect.IEffectStrategy;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class BaseTerraArrowItem
extends ArrowItem {
    public static final String ARROW_TRANSFORM_TEXT = "tooltip.item.confluence.arrow_transform";
    public static final String BOW_FULL_PULL_ON_HIT_EFFECTS_TEXT = "tooltip.item.confluence.bow_full_pull_on_hit_effects";
    public static final String ON_HIT_EFFECTS_TEXT = "tooltip.item.confluence.on_hit_effects";
    public static final String MAX_COUNT_TEXT = "tooltip.item.confluence.max_count";
    public static final String ATTACK_DAMAGE_TEXT = "attribute.name.generic.attack_damage";
    @Nullable
    protected final BaseArrowEntity.Factory modifier;
    protected BaseArrowEntity.Builder attributes;

    public BaseTerraArrowItem(ModRarity rarity) {
        this(rarity, null);
    }

    public BaseTerraArrowItem(ModRarity rarity, @Nullable BaseArrowEntity.Factory modifier) {
        super(new Item.Properties().component(ConfluenceMagicLib.MOD_RARITY, (Object)rarity));
        this.modifier = modifier;
        if (modifier != null) {
            this.attributes = modifier.attr.get();
        }
    }

    public @Nullable BaseArrowEntity.Factory getModifier() {
        return this.modifier;
    }

    public AbstractArrow createArrow(Level level, ItemStack stack, LivingEntity shooter, @Nullable ItemStack weapon) {
        Item item = stack.getItem();
        if (item instanceof BaseTerraArrowItem) {
            BaseTerraArrowItem arrowItem = (BaseTerraArrowItem)item;
            if (arrowItem.modifier != null) {
                BaseArrowEntity arrow;
                Item item2;
                if (weapon != null && (item2 = weapon.getItem()) instanceof ITerraArrowProjectileWeaponItem) {
                    ITerraArrowProjectileWeaponItem item3 = (ITerraArrowProjectileWeaponItem)item2;
                    arrow = new BaseArrowEntity((EntityType<? extends AbstractArrow>)((EntityType)ModEntities.ARROW_PROJECTILE.get()), shooter, this.getDefaultInstance(), weapon, this, item3.getModifyArrowBuilder());
                } else {
                    arrow = new BaseArrowEntity((EntityType<? extends AbstractArrow>)((EntityType)ModEntities.ARROW_PROJECTILE.get()), shooter, this.getDefaultInstance(), weapon, this);
                }
                return arrow;
            }
        }
        return super.createArrow(level, stack, shooter, weapon);
    }

    public Projectile asProjectile(Level level, Position pos, ItemStack stack, Direction direction) {
        Item item = stack.getItem();
        if (item instanceof BaseTerraArrowItem) {
            BaseTerraArrowItem arrowItem = (BaseTerraArrowItem)item;
            if (arrowItem.modifier != null) {
                return new BaseArrowEntity((EntityType<? extends AbstractArrow>)((EntityType)ModEntities.ARROW_PROJECTILE.get()), pos.x(), pos.y(), pos.z(), level, stack.copyWithCount(1), null, this);
            }
        }
        return super.asProjectile(level, pos, stack, direction);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        if (this.attributes == null) {
            return;
        }
        tooltipComponents.add((Component)Component.translatable((String)"tooltip.item.confluence.additional_attack_damage").append(": +").append(String.format("%.1f", Float.valueOf(this.attributes.base_damage))).withColor(65280));
        if (this.attributes.onHitEffects != null) {
            IEffectStrategy.appendDescriptions(tooltipComponents, this.attributes.onHitEffects, (Component)Component.translatable((String)ON_HIT_EFFECTS_TEXT).append(": ").withColor(0xFF00FF));
        }
        if ((this.attributes.getType() & 2) != 0) {
            tooltipComponents.add((Component)Component.translatable((String)"tooltip.item.confluence.no_gravity"));
        }
        if ((this.attributes.getType() & 8) != 0) {
            tooltipComponents.add((Component)Component.translatable((String)"tooltip.item.confluence.cause_fire"));
        }
        if ((this.attributes.getType() & 1) != 0) {
            tooltipComponents.add((Component)Component.translatable((String)"tooltip.item.confluence.can_penetrate"));
        }
    }

    public static void addDamageHoverText(List<Component> tooltipComponents, ModifyArrowBuilder modifyArrowBuilder, float baseDamage) {
        tooltipComponents.add((Component)BaseTerraArrowItem.tooltip(ATTACK_DAMAGE_TEXT).append(String.format("%.1f", Float.valueOf(baseDamage))).withColor(65280));
        if (modifyArrowBuilder.multiShoot > 1) {
            tooltipComponents.add((Component)BaseTerraArrowItem.tooltip(MAX_COUNT_TEXT).append(String.format("%d", modifyArrowBuilder.multiShoot)).withColor(65280));
        }
    }

    public static void addHitEffectHoverText(ItemStack weapon, List<Component> tooltipComponents) {
        EffectStrategyComponent hitEffect = (EffectStrategyComponent)weapon.get(TEDataComponentTypes.EFFECT_STRATEGY);
        if (hitEffect != null) {
            IEffectStrategy.appendDescription(tooltipComponents, (List)hitEffect.effects(), (Component)BaseTerraArrowItem.tooltip(ON_HIT_EFFECTS_TEXT).withColor(0xFF00FF));
        }
    }

    public static void addEntityTransformHoverText(List<Component> tooltipComponents, ModifyArrowBuilder modifyArrowBuilder, BaseArrowEntity.Builder arrowModifier) {
        if (modifyArrowBuilder.entityTransform != null) {
            tooltipComponents.add((Component)BaseTerraArrowItem.tooltip(ARROW_TRANSFORM_TEXT).append(modifyArrowBuilder.entityTransform.type().getDescription()).withColor(15839476));
            return;
        }
        BaseTerraArrowItem transformArrow = arrowModifier.getTransformArrow();
        if (transformArrow != null) {
            tooltipComponents.add((Component)BaseTerraArrowItem.tooltip(ARROW_TRANSFORM_TEXT).append((Component)Component.translatable((String)transformArrow.getDescriptionId())).withColor(15839476));
        }
    }

    public static void addFullPullHitEffectHoverText(ItemStack weapon, List<Component> tooltipComponents) {
        EffectStrategyComponent fullPullHitEffect = (EffectStrategyComponent)weapon.get(TEDataComponentTypes.BOW_FULL_CHARGE_EFFECT_STRATEGY);
        if (fullPullHitEffect != null) {
            IEffectStrategy.appendDescription(tooltipComponents, (List)fullPullHitEffect.effects(), (Component)BaseTerraArrowItem.tooltip(BOW_FULL_PULL_ON_HIT_EFFECTS_TEXT).withColor(0xFF00FF));
        }
    }

    private static MutableComponent tooltip(String text) {
        return Component.translatable((String)text).append(": ");
    }

    public static class ModifyArrowBuilder {
        public List<Function<Item.Properties, Item.Properties>> modifyProperties = new ArrayList<Function<Item.Properties, Item.Properties>>();
        public List<Consumer<BaseArrowEntity.Builder>> modifyArrowBuilder = new ArrayList<Consumer<BaseArrowEntity.Builder>>();
        public int multiShoot = 1;
        public Predicate<ItemStack> canMultiShoot = ammo -> false;
        public MultiShootOffsetFunction multiShootOffset;
        public EntityTransform entityTransform;
        public float inaccuracy;

        public void applyModifiers(BaseArrowEntity.Builder modifyArrow) {
            this.modifyArrowBuilder.forEach(m -> m.accept(modifyArrow));
        }

        public ModifyArrowBuilder setEntityTransform(EntityTransform transformArrow) {
            this.entityTransform = transformArrow;
            return this;
        }

        public ModifyArrowBuilder setMultiShoot(int multiShoot) {
            this.multiShoot = multiShoot;
            return this;
        }

        public ModifyArrowBuilder setMultiShoot(int multiShoot, MultiShootOffsetFunction multiShootOffset) {
            this.multiShoot = multiShoot;
            this.multiShootOffset = multiShootOffset;
            return this;
        }

        public ModifyArrowBuilder setCanMultiShoot(Predicate<ItemStack> canMultiShoot) {
            this.canMultiShoot = canMultiShoot;
            return this;
        }

        public ModifyArrowBuilder setDuration(int duration) {
            this.modifyProperties.add(p -> p.durability(duration));
            return this;
        }

        public ModifyArrowBuilder setOnHitEffect(EffectStrategyComponent component) {
            this.modifyProperties.add(p -> p.component(TEDataComponentTypes.EFFECT_STRATEGY, (Object)component));
            this.addModifyArrowBuilder(m -> m.addOnHitEffect(component));
            return this;
        }

        public ModifyArrowBuilder setFullPullHitEffect(EffectStrategyComponent component) {
            this.modifyProperties.add(p -> p.component(TEDataComponentTypes.BOW_FULL_CHARGE_EFFECT_STRATEGY, (Object)component));
            this.addModifyArrowBuilder(m -> m.addFullPullHitEffect(component));
            return this;
        }

        public ModifyArrowBuilder setArrowTransform(BaseTerraArrowItem arrow) {
            this.modifyArrowBuilder.add(m -> m.setTransformArrow(arrow));
            return this;
        }

        public ModifyArrowBuilder setUnBreakable() {
            this.modifyProperties.add(p -> p.component(DataComponents.UNBREAKABLE, (Object)new Unbreakable(true)));
            return this;
        }

        public ModifyArrowBuilder setRarity(ModRarity rarity) {
            this.modifyProperties.add(p -> p.component(ConfluenceMagicLib.MOD_RARITY, (Object)rarity));
            return this;
        }

        public ModifyArrowBuilder addModifyArrowBuilder(Consumer<BaseArrowEntity.Builder> modifyArrowBuilder) {
            this.modifyArrowBuilder.add(modifyArrowBuilder);
            return this;
        }

        public ModifyArrowBuilder setInaccuracy(float inaccuracy) {
            this.inaccuracy = inaccuracy;
            return this;
        }

        public Item.Properties buildProperties(Item.Properties properties) {
            for (Function<Item.Properties, Item.Properties> f : this.modifyProperties) {
                f.apply(properties);
            }
            return properties;
        }

        @FunctionalInterface
        public static interface MultiShootOffsetFunction {
            public Vec3 apply(int var1, int var2);
        }
    }

    public record EntityTransform(EntityType<? extends AbstractArrow> type, ArrowFactory factory) {
        public static EntityTransform create(EntityType<? extends AbstractArrow> type, ArrowFactory factory) {
            return new EntityTransform(type, factory);
        }
    }

    @FunctionalInterface
    public static interface ArrowFactory {
        public BaseArrowEntity create(EntityType<? extends AbstractArrow> var1, LivingEntity var2, ItemStack var3, ItemStack var4, @Nullable BaseTerraArrowItem var5, ModifyArrowBuilder var6);
    }
}

