/*
 * Decompiled with CFR 0.152.
 */
package org.confluence.mod.common.item.armor;

import com.google.common.base.Suppliers;
import java.util.Collections;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import org.confluence.lib.ConfluenceMagicLib;
import org.confluence.lib.common.component.ModRarity;
import org.confluence.mod.Confluence;
import org.confluence.mod.client.renderer.item.NormalArmorItemRenderer;
import org.confluence.mod.common.init.armor.ModArmorMaterials;
import org.confluence.mod.common.item.armor.BaseArmorItem;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.animatable.client.GeoRenderProvider;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;

public class BaseVanityArmorItem
extends BaseArmorItem
implements GeoItem {
    protected final AnimatableInstanceCache CACHE = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    protected final String name;

    public BaseVanityArmorItem(String name, ArmorItem.Type type, ModRarity rarity) {
        this(name, ModArmorMaterials.VANITY_ARMOR_MATERIALS, type, new Item.Properties(), rarity);
    }

    public BaseVanityArmorItem(String name, Holder<ArmorMaterial> material, ArmorItem.Type type, ModRarity rarity) {
        this(name, material, type, new Item.Properties(), rarity);
    }

    public BaseVanityArmorItem(String name, Holder<ArmorMaterial> material, ArmorItem.Type type, Item.Properties properties, ModRarity rarity) {
        super(material, type, properties.stacksTo(1).component(ConfluenceMagicLib.MOD_RARITY, (Object)rarity));
        this.name = name;
        this.defaultModifiers = Suppliers.memoize(() -> new ItemAttributeModifiers(Collections.emptyList(), false));
    }

    public boolean isEnchantable(ItemStack stack) {
        return false;
    }

    public void createGeoRenderer(Consumer<GeoRenderProvider> consumer) {
        consumer.accept(new GeoRenderProvider(){
            private NormalArmorItemRenderer<BaseVanityArmorItem> renderer;

            public <T extends LivingEntity> HumanoidModel<?> getGeoArmorRenderer(@Nullable T livingEntity, ItemStack itemStack, @Nullable EquipmentSlot equipmentSlot, @Nullable HumanoidModel<T> original) {
                if (this.renderer == null) {
                    ResourceLocation textureResource = Confluence.asResource("textures/item/" + BaseVanityArmorItem.this.name + ".png");
                    this.renderer = Minecraft.getInstance().getResourceManager().getResource(textureResource).isEmpty() ? new NormalArmorItemRenderer("vanity_armor/dead_mans_seater") : new NormalArmorItemRenderer(BaseVanityArmorItem.this.name);
                }
                return this.renderer;
            }
        });
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.CACHE;
    }
}

